% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_get_reserved_node_exchange_configuration_options}
\alias{redshift_get_reserved_node_exchange_configuration_options}
\title{Gets the configuration options for the reserved-node exchange}
\usage{
redshift_get_reserved_node_exchange_configuration_options(
  ActionType,
  ClusterIdentifier = NULL,
  SnapshotIdentifier = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{ActionType}{[required] The action type of the reserved-node configuration. The action type can
be an exchange initiated from either a snapshot or a resize.}

\item{ClusterIdentifier}{The identifier for the cluster that is the source for a reserved-node
exchange.}

\item{SnapshotIdentifier}{The identifier for the snapshot that is the source for the reserved-node
exchange.}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{Marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=redshift_get_reserved_node_exchange_configuration_options]{get_reserved_node_exchange_configuration_options}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by the \code{MaxRecords}
parameter. You can retrieve the next set of response records by
providing the returned marker value in the \code{Marker} parameter and
retrying the request.}
}
\description{
Gets the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node offering. Details include the node type, the price, the node count, and the offering type.

See \url{https://www.paws-r-sdk.com/docs/redshift_get_reserved_node_exchange_configuration_options/} for full documentation.
}
\keyword{internal}
