% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud9_operations.R
\name{cloud9_create_environment_membership}
\alias{cloud9_create_environment_membership}
\title{Adds an environment member to an AWS Cloud9 development environment}
\usage{
cloud9_create_environment_membership(environmentId, userArn,
  permissions)
}
\arguments{
\item{environmentId}{[required] The ID of the environment that contains the environment member you want
to add.}

\item{userArn}{[required] The Amazon Resource Name (ARN) of the environment member you want to
add.}

\item{permissions}{[required] The type of environment member permissions you want to associate with
this environment member. Available values include:
\itemize{
\item \code{read-only}: Has read-only access to the environment.
\item \code{read-write}: Has read-write access to the environment.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  membership = list(
    permissions = "owner"|"read-write"|"read-only",
    userId = "string",
    userArn = "string",
    environmentId = "string",
    lastAccess = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Adds an environment member to an AWS Cloud9 development environment.
}
\section{Request syntax}{
\preformatted{svc$create_environment_membership(
  environmentId = "string",
  userArn = "string",
  permissions = "read-write"|"read-only"
)
}
}

\examples{
\dontrun{
# 
svc$create_environment_membership(
  environmentId = "8d9967e2f0624182b74e7690ad69ebEX",
  permissions = "read-write",
  userArn = "arn:aws:iam::123456789012:user/AnotherDemoUser"
)
}

}
\keyword{internal}
