% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_list_tags_for_resource}
\alias{xray_list_tags_for_resource}
\title{Returns a list of tags that are applied to the specified AWS X-Ray group
or sampling rule}
\usage{
xray_list_tags_for_resource(ResourceARN, NextToken)
}
\arguments{
\item{ResourceARN}{[required] The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.}

\item{NextToken}{A pagination token. If multiple pages of results are returned, use the
\code{NextToken} value returned with the current page of results as the value
of this parameter to get the next page of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of tags that are applied to the specified AWS X-Ray group
or sampling rule.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceARN = "string",
  NextToken = "string"
)
}
}

\keyword{internal}
