% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_list_packages}
\alias{codeartifact_list_packages}
\title{Returns a list of PackageSummary objects for packages in a repository
that match the request parameters}
\usage{
codeartifact_list_packages(
  domain,
  domainOwner = NULL,
  repository,
  format = NULL,
  namespace = NULL,
  packagePrefix = NULL,
  maxResults = NULL,
  nextToken = NULL,
  publish = NULL,
  upstream = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the repository that contains the
requested packages.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository that contains the requested packages.}

\item{format}{The format used to filter requested packages. Only packages from the
provided format will be returned.}

\item{namespace}{The namespace used to filter requested packages. Only packages with the
provided namespace will be returned. The package component that
specifies its namespace depends on its type. For example:
\itemize{
\item The namespace of a Maven package is its \code{groupId}.
\item The namespace of an npm package is its \code{scope}.
\item Python and NuGet packages do not contain a corresponding component,
packages of those formats do not have a namespace.
}}

\item{packagePrefix}{A prefix used to filter requested packages. Only packages with names
that start with \code{packagePrefix} are returned.}

\item{maxResults}{The maximum number of results to return per page.}

\item{nextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{publish}{The value of the \code{Publish} package origin control restriction used to
filter requested packages. Only packages with the provided restriction
are returned. For more information, see
\href{https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html}{PackageOriginRestrictions}.}

\item{upstream}{The value of the \code{Upstream} package origin control restriction used to
filter requested packages. Only packages with the provided restriction
are returned. For more information, see
\href{https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html}{PackageOriginRestrictions}.}
}
\description{
Returns a list of \href{https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html}{PackageSummary} objects for packages in a repository that match the request parameters.

See \url{https://paws-r.github.io/docs/codeartifact/list_packages.html} for full documentation.
}
\keyword{internal}
