% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_create_deployment}
\alias{codedeploy_create_deployment}
\title{Deploys an application revision through the specified deployment group}
\usage{
codedeploy_create_deployment(
  applicationName,
  deploymentGroupName = NULL,
  revision = NULL,
  deploymentConfigName = NULL,
  description = NULL,
  ignoreApplicationStopFailures = NULL,
  targetInstances = NULL,
  autoRollbackConfiguration = NULL,
  updateOutdatedInstancesOnly = NULL,
  fileExistsBehavior = NULL
)
}
\arguments{
\item{applicationName}{[required] The name of an AWS CodeDeploy application associated with the IAM user
or AWS account.}

\item{deploymentGroupName}{The name of the deployment group.}

\item{revision}{The type and location of the revision to deploy.}

\item{deploymentConfigName}{The name of a deployment configuration associated with the IAM user or
AWS account.

If not specified, the value configured in the deployment group is used
as the default. If the deployment group does not have a deployment
configuration associated with it, \code{CodeDeployDefault}.\code{OneAtATime} is
used by default.}

\item{description}{A comment about the deployment.}

\item{ignoreApplicationStopFailures}{If true, then if an \code{ApplicationStop}, \code{BeforeBlockTraffic}, or
\code{AfterBlockTraffic} deployment lifecycle event to an instance fails,
then the deployment continues to the next deployment lifecycle event.
For example, if \code{ApplicationStop} fails, the deployment continues with
\code{DownloadBundle}. If \code{BeforeBlockTraffic} fails, the deployment
continues with \code{BlockTraffic}. If \code{AfterBlockTraffic} fails, the
deployment continues with \code{ApplicationStop}.

If false or not specified, then if a lifecycle event fails during a
deployment to an instance, that deployment fails. If deployment to that
instance is part of an overall deployment and the number of healthy
hosts is not less than the minimum number of healthy hosts, then a
deployment to the next instance is attempted.

During a deployment, the AWS CodeDeploy agent runs the scripts specified
for \code{ApplicationStop}, \code{BeforeBlockTraffic}, and \code{AfterBlockTraffic} in
the AppSpec file from the previous successful deployment. (All other
scripts are run from the AppSpec file in the current deployment.) If one
of these scripts contains an error and does not run successfully, the
deployment can fail.

If the cause of the failure is a script from the last successful
deployment that will never run successfully, create a new deployment and
use \code{ignoreApplicationStopFailures} to specify that the
\code{ApplicationStop}, \code{BeforeBlockTraffic}, and \code{AfterBlockTraffic}
failures should be ignored.}

\item{targetInstances}{Information about the instances that belong to the replacement
environment in a blue/green deployment.}

\item{autoRollbackConfiguration}{Configuration information for an automatic rollback that is added when a
deployment is created.}

\item{updateOutdatedInstancesOnly}{Indicates whether to deploy to all instances or only to instances that
are not running the latest application revision.}

\item{fileExistsBehavior}{Information about how AWS CodeDeploy handles files that already exist in
a deployment target location but weren't part of the previous successful
deployment.

The \code{fileExistsBehavior} parameter takes any of the following values:
\itemize{
\item DISALLOW: The deployment fails. This is also the default behavior if
no option is specified.
\item OVERWRITE: The version of the file from the application revision
currently being deployed replaces the version already on the
instance.
\item RETAIN: The version of the file already on the instance is kept and
used as part of the new deployment.
}}
}
\description{
Deploys an application revision through the specified deployment group.

See \url{https://paws-r.github.io/docs/codedeploy/create_deployment.html} for full documentation.
}
\keyword{internal}
