% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drs_operations.R
\name{drs_create_replication_configuration_template}
\alias{drs_create_replication_configuration_template}
\title{Creates a new ReplicationConfigurationTemplate}
\usage{
drs_create_replication_configuration_template(
  associateDefaultSecurityGroup,
  bandwidthThrottling,
  createPublicIP,
  dataPlaneRouting,
  defaultLargeStagingDiskType,
  ebsEncryption,
  ebsEncryptionKeyArn = NULL,
  pitPolicy,
  replicationServerInstanceType,
  replicationServersSecurityGroupsIDs,
  stagingAreaSubnetId,
  stagingAreaTags,
  tags = NULL,
  useDedicatedReplicationServer
)
}
\arguments{
\item{associateDefaultSecurityGroup}{[required] Whether to associate the default Elastic Disaster Recovery Security
group with the Replication Configuration Template.}

\item{bandwidthThrottling}{[required] Configure bandwidth throttling for the outbound data transfer rate of
the Source Server in Mbps.}

\item{createPublicIP}{[required] Whether to create a Public IP for the Recovery Instance by default.}

\item{dataPlaneRouting}{[required] The data plane routing mechanism that will be used for replication.}

\item{defaultLargeStagingDiskType}{[required] The Staging Disk EBS volume type to be used during replication.}

\item{ebsEncryption}{[required] The type of EBS encryption to be used during replication.}

\item{ebsEncryptionKeyArn}{The ARN of the EBS encryption key to be used during replication.}

\item{pitPolicy}{[required] The Point in time (PIT) policy to manage snapshots taken during
replication.}

\item{replicationServerInstanceType}{[required] The instance type to be used for the replication server.}

\item{replicationServersSecurityGroupsIDs}{[required] The security group IDs that will be used by the replication server.}

\item{stagingAreaSubnetId}{[required] The subnet to be used by the replication staging area.}

\item{stagingAreaTags}{[required] A set of tags to be associated with all resources created in the
replication staging area: EC2 replication server, EBS volumes, EBS
snapshots, etc.}

\item{tags}{A set of tags to be associated with the Replication Configuration
Template resource.}

\item{useDedicatedReplicationServer}{[required] Whether to use a dedicated Replication Server in the replication staging
area.}
}
\description{
Creates a new ReplicationConfigurationTemplate.

See \url{https://paws-r.github.io/docs/drs/create_replication_configuration_template.html} for full documentation.
}
\keyword{internal}
