% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_delete_package_versions}
\alias{codeartifact_delete_package_versions}
\title{Deletes one or more versions of a package}
\usage{
codeartifact_delete_package_versions(
  domain,
  domainOwner = NULL,
  repository,
  format,
  namespace = NULL,
  package,
  versions,
  expectedStatus = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the package to delete.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository that contains the package versions to delete.}

\item{format}{[required] The format of the package versions to delete.}

\item{namespace}{The namespace of the package versions to be deleted. The package version
component that specifies its namespace depends on its type. For example:
\itemize{
\item The namespace of a Maven package version is its \code{groupId}. The
namespace is required when deleting Maven package versions.
\item The namespace of an npm package version is its \code{scope}.
\item Python and NuGet package versions do not contain a corresponding
component, package versions of those formats do not have a
namespace.
\item The namespace of a generic package is its \code{namespace}.
}}

\item{package}{[required] The name of the package with the versions to delete.}

\item{versions}{[required] An array of strings that specify the versions of the package to delete.}

\item{expectedStatus}{The expected status of the package version to delete.}
}
\description{
Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If you want to remove a package version from your repository and be able to restore it later, set its status to \code{Archived}. Archived packages cannot be downloaded from a repository and don't show up with list package APIs (for example, \code{\link[=codeartifact_list_package_versions]{list_package_versions}}), but you can restore them using \code{\link[=codeartifact_update_package_versions_status]{update_package_versions_status}}.

See \url{https://www.paws-r-sdk.com/docs/codeartifact_delete_package_versions/} for full documentation.
}
\keyword{internal}
