% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivschat_operations.R
\name{ivschat_create_logging_configuration}
\alias{ivschat_create_logging_configuration}
\title{Creates a logging configuration that allows clients to store and record
sent messages}
\usage{
ivschat_create_logging_configuration(
  destinationConfiguration,
  name = NULL,
  tags = NULL
)
}
\arguments{
\item{destinationConfiguration}{[required] A complex type that contains a destination configuration for where chat
content will be logged. There can be only one type of destination
(\code{cloudWatchLogs}, \code{firehose}, or \code{s3}) in a \code{destinationConfiguration}.}

\item{name}{Logging-configuration name. The value does not need to be unique.}

\item{tags}{Tags to attach to the resource. Array of maps, each of the form
\code{string:string (key:value)}. See \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging AWS Resources}
for details, including restrictions that apply to tags and "Tag naming
limits and requirements"; Amazon IVS Chat has no constraints on tags
beyond what is documented there.}
}
\description{
Creates a logging configuration that allows clients to store and record sent messages.

See \url{https://www.paws-r-sdk.com/docs/ivschat_create_logging_configuration/} for full documentation.
}
\keyword{internal}
