% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_describe_project}
\alias{sagemaker_describe_project}
\title{Describes the details of a project}
\usage{
sagemaker_describe_project(ProjectName)
}
\arguments{
\item{ProjectName}{[required] The name of the project to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProjectArn = "string",
  ProjectName = "string",
  ProjectId = "string",
  ProjectDescription = "string",
  ServiceCatalogProvisioningDetails = list(
    ProductId = "string",
    ProvisioningArtifactId = "string",
    PathId = "string",
    ProvisioningParameters = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  ),
  ServiceCatalogProvisionedProductDetails = list(
    ProvisionedProductId = "string",
    ProvisionedProductStatusMessage = "string"
  ),
  ProjectStatus = "Pending"|"CreateInProgress"|"CreateCompleted"|"CreateFailed"|"DeleteInProgress"|"DeleteFailed"|"DeleteCompleted",
  CreatedBy = list(
    UserProfileArn = "string",
    UserProfileName = "string",
    DomainId = "string"
  ),
  CreationTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Describes the details of a project.
}
\section{Request syntax}{
\preformatted{svc$describe_project(
  ProjectName = "string"
)
}
}

\keyword{internal}
