% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_create_resource_policy_statement}
\alias{lexmodelsv2_create_resource_policy_statement}
\title{Adds a new resource policy statement to a bot or bot alias}
\usage{
lexmodelsv2_create_resource_policy_statement(
  resourceArn,
  statementId,
  effect,
  principal,
  action,
  condition = NULL,
  expectedRevisionId = NULL
)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the bot or bot alias that the resource
policy is attached to.}

\item{statementId}{[required] The name of the statement. The ID is the same as the \code{Sid} IAM property.
The statement name must be unique within the policy. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html}{IAM JSON policy elements: Sid}.}

\item{effect}{[required] Determines whether the statement allows or denies access to the
resource.}

\item{principal}{[required] An IAM principal, such as an IAM user, IAM role, or Amazon Web Services
services that is allowed or denied access to a resource. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html}{Amazon Web Services JSON policy elements: Principal}.}

\item{action}{[required] The Amazon Lex action that this policy either allows or denies. The
action must apply to the resource type of the specified ARN. For more
information, see \href{https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html}{Actions, resources, and condition keys for Amazon Lex V2}.}

\item{condition}{Specifies a condition when the policy is in effect. If the principal of
the policy is a service principal, you must provide two condition
blocks, one with a SourceAccount global condition key and one with a
SourceArn global condition key.

For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html}{IAM JSON policy elements: Condition}
.}

\item{expectedRevisionId}{The identifier of the revision of the policy to edit. If this revision
ID doesn't match the current revision ID, Amazon Lex throws an
exception.

If you don't specify a revision, Amazon Lex overwrites the contents of
the policy with the new values.}
}
\description{
Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn't exist, a new policy is created.

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_create_resource_policy_statement/} for full documentation.
}
\keyword{internal}
