% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_start_media_analysis_job}
\alias{rekognition_start_media_analysis_job}
\title{Initiates a new media analysis job}
\usage{
rekognition_start_media_analysis_job(
  ClientRequestToken = NULL,
  JobName = NULL,
  OperationsConfig,
  Input,
  OutputConfig,
  KmsKeyId = NULL
)
}
\arguments{
\item{ClientRequestToken}{Idempotency token used to prevent the accidental creation of duplicate
versions. If you use the same token with multiple
\code{StartMediaAnalysisJobRequest} requests, the same response is returned.
Use \code{ClientRequestToken} to prevent the same request from being
processed more than once.}

\item{JobName}{The name of the job. Does not have to be unique.}

\item{OperationsConfig}{[required] Configuration options for the media analysis job to be created.}

\item{Input}{[required] Input data to be analyzed by the job.}

\item{OutputConfig}{[required] The Amazon S3 bucket location to store the results.}

\item{KmsKeyId}{The identifier of customer managed AWS KMS key (name or ARN). The key is
used to encrypt images copied into the service. The key is also used to
encrypt results and manifest files written to the output Amazon S3
bucket.}
}
\description{
Initiates a new media analysis job. Accepts a manifest file in an Amazon S3 bucket. The output is a manifest file and a summary of the manifest stored in the Amazon S3 bucket.

See \url{https://www.paws-r-sdk.com/docs/rekognition_start_media_analysis_job/} for full documentation.
}
\keyword{internal}
