% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookoutequipment_operations.R
\name{lookoutequipment_list_model_versions}
\alias{lookoutequipment_list_model_versions}
\title{Generates a list of all model versions for a given model, including the
model version, model version ARN, and status}
\usage{
lookoutequipment_list_model_versions(
  ModelName,
  NextToken = NULL,
  MaxResults = NULL,
  Status = NULL,
  SourceType = NULL,
  CreatedAtEndTime = NULL,
  CreatedAtStartTime = NULL,
  MaxModelVersion = NULL,
  MinModelVersion = NULL
)
}
\arguments{
\item{ModelName}{[required] Then name of the machine learning model for which the model versions are
to be listed.}

\item{NextToken}{If the total number of results exceeds the limit that the response can
display, the response returns an opaque pagination token indicating
where to continue the listing of machine learning model versions. Use
this token in the \code{NextToken} field in the request to list the next page
of results.}

\item{MaxResults}{Specifies the maximum number of machine learning model versions to list.}

\item{Status}{Filter the results based on the current status of the model version.}

\item{SourceType}{Filter the results based on the way the model version was generated.}

\item{CreatedAtEndTime}{Filter results to return all the model versions created before this
time.}

\item{CreatedAtStartTime}{Filter results to return all the model versions created after this time.}

\item{MaxModelVersion}{Specifies the highest version of the model to return in the list.}

\item{MinModelVersion}{Specifies the lowest version of the model to return in the list.}
}
\description{
Generates a list of all model versions for a given model, including the model version, model version ARN, and status. To list a subset of versions, use the \code{MaxModelVersion} and \code{MinModelVersion} fields.

See \url{https://www.paws-r-sdk.com/docs/lookoutequipment_list_model_versions/} for full documentation.
}
\keyword{internal}
