% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_events}
\alias{health_describe_events}
\title{Returns information about events that meet the specified filter criteria}
\usage{
health_describe_events(filter, nextToken, maxResults, locale)
}
\arguments{
\item{filter}{Values to narrow the results returned.}

\item{nextToken}{If the results of a search are large, only a portion of the results are
returned, and a \code{nextToken} pagination token is returned in the
response. To retrieve the next batch of results, reissue the search
request and include the returned token. When all results have been
returned, the response does not contain a pagination token value.}

\item{maxResults}{The maximum number of items to return in one batch, between 10 and 100,
inclusive.}

\item{locale}{The locale (language) to return information in. English (en) is the
default and the only supported value at this time.}
}
\description{
Returns information about events that meet the specified filter
criteria. Events are returned in a summary form and do not include the
detailed description, any additional metadata that depends on the event
type, or any affected resources. To retrieve that information, use the
DescribeEventDetails and DescribeAffectedEntities operations.
}
\details{
If no filter criteria are specified, all events are returned. Results
are sorted by \code{lastModifiedTime}, starting with the most recent.
}
\section{Request syntax}{
\preformatted{svc$describe_events(
  filter = list(
    eventArns = list(
      "string"
    ),
    eventTypeCodes = list(
      "string"
    ),
    services = list(
      "string"
    ),
    regions = list(
      "string"
    ),
    availabilityZones = list(
      "string"
    ),
    startTimes = list(
      list(
        from = as.POSIXct(
          "2015-01-01"
        ),
        to = as.POSIXct(
          "2015-01-01"
        )
      )
    ),
    endTimes = list(
      list(
        from = as.POSIXct(
          "2015-01-01"
        ),
        to = as.POSIXct(
          "2015-01-01"
        )
      )
    ),
    lastUpdatedTimes = list(
      list(
        from = as.POSIXct(
          "2015-01-01"
        ),
        to = as.POSIXct(
          "2015-01-01"
        )
      )
    ),
    entityArns = list(
      "string"
    ),
    entityValues = list(
      "string"
    ),
    eventTypeCategories = list(
      "issue"|"accountNotification"|"scheduledChange"
    ),
    tags = list(
      list(
        "string"
      )
    ),
    eventStatusCodes = list(
      "open"|"closed"|"upcoming"
    )
  ),
  nextToken = "string",
  maxResults = 123,
  locale = "string"
)
}
}

\keyword{internal}
