# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include prometheusservice_service.R
NULL

#' Create an alert manager definition
#'
#' @description
#' Create an alert manager definition.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/create_alert_manager_definition.html](https://paws-r.github.io/docs/prometheusservice/create_alert_manager_definition.html) for full documentation.
#'
#' @param clientToken Optional, unique, case-sensitive, user-provided identifier to ensure the
#' idempotency of the request.
#' @param data &#91;required&#93; The alert manager definition data.
#' @param workspaceId &#91;required&#93; The ID of the workspace in which to create the alert manager definition.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_create_alert_manager_definition
prometheusservice_create_alert_manager_definition <- function(clientToken = NULL, data, workspaceId) {
  op <- new_operation(
    name = "CreateAlertManagerDefinition",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/alertmanager/definition",
    paginator = list()
  )
  input <- .prometheusservice$create_alert_manager_definition_input(clientToken = clientToken, data = data, workspaceId = workspaceId)
  output <- .prometheusservice$create_alert_manager_definition_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$create_alert_manager_definition <- prometheusservice_create_alert_manager_definition

#' Create a rule group namespace
#'
#' @description
#' Create a rule group namespace.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/create_rule_groups_namespace.html](https://paws-r.github.io/docs/prometheusservice/create_rule_groups_namespace.html) for full documentation.
#'
#' @param clientToken Optional, unique, case-sensitive, user-provided identifier to ensure the
#' idempotency of the request.
#' @param data &#91;required&#93; The namespace data that define the rule groups.
#' @param name &#91;required&#93; The rule groups namespace name.
#' @param tags Optional, user-provided tags for this rule groups namespace.
#' @param workspaceId &#91;required&#93; The ID of the workspace in which to create the rule group namespace.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_create_rule_groups_namespace
prometheusservice_create_rule_groups_namespace <- function(clientToken = NULL, data, name, tags = NULL, workspaceId) {
  op <- new_operation(
    name = "CreateRuleGroupsNamespace",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/rulegroupsnamespaces",
    paginator = list()
  )
  input <- .prometheusservice$create_rule_groups_namespace_input(clientToken = clientToken, data = data, name = name, tags = tags, workspaceId = workspaceId)
  output <- .prometheusservice$create_rule_groups_namespace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$create_rule_groups_namespace <- prometheusservice_create_rule_groups_namespace

#' Creates a new AMP workspace
#'
#' @description
#' Creates a new AMP workspace.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/create_workspace.html](https://paws-r.github.io/docs/prometheusservice/create_workspace.html) for full documentation.
#'
#' @param alias An optional user-assigned alias for this workspace. This alias is for
#' user reference and does not need to be unique.
#' @param clientToken Optional, unique, case-sensitive, user-provided identifier to ensure the
#' idempotency of the request.
#' @param tags Optional, user-provided tags for this workspace.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_create_workspace
prometheusservice_create_workspace <- function(alias = NULL, clientToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateWorkspace",
    http_method = "POST",
    http_path = "/workspaces",
    paginator = list()
  )
  input <- .prometheusservice$create_workspace_input(alias = alias, clientToken = clientToken, tags = tags)
  output <- .prometheusservice$create_workspace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$create_workspace <- prometheusservice_create_workspace

#' Deletes an alert manager definition
#'
#' @description
#' Deletes an alert manager definition.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/delete_alert_manager_definition.html](https://paws-r.github.io/docs/prometheusservice/delete_alert_manager_definition.html) for full documentation.
#'
#' @param clientToken Optional, unique, case-sensitive, user-provided identifier to ensure the
#' idempotency of the request.
#' @param workspaceId &#91;required&#93; The ID of the workspace in which to delete the alert manager definition.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_delete_alert_manager_definition
prometheusservice_delete_alert_manager_definition <- function(clientToken = NULL, workspaceId) {
  op <- new_operation(
    name = "DeleteAlertManagerDefinition",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}/alertmanager/definition",
    paginator = list()
  )
  input <- .prometheusservice$delete_alert_manager_definition_input(clientToken = clientToken, workspaceId = workspaceId)
  output <- .prometheusservice$delete_alert_manager_definition_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$delete_alert_manager_definition <- prometheusservice_delete_alert_manager_definition

#' Delete a rule groups namespace
#'
#' @description
#' Delete a rule groups namespace.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/delete_rule_groups_namespace.html](https://paws-r.github.io/docs/prometheusservice/delete_rule_groups_namespace.html) for full documentation.
#'
#' @param clientToken Optional, unique, case-sensitive, user-provided identifier to ensure the
#' idempotency of the request.
#' @param name &#91;required&#93; The rule groups namespace name.
#' @param workspaceId &#91;required&#93; The ID of the workspace to delete rule group definition.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_delete_rule_groups_namespace
prometheusservice_delete_rule_groups_namespace <- function(clientToken = NULL, name, workspaceId) {
  op <- new_operation(
    name = "DeleteRuleGroupsNamespace",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}/rulegroupsnamespaces/{name}",
    paginator = list()
  )
  input <- .prometheusservice$delete_rule_groups_namespace_input(clientToken = clientToken, name = name, workspaceId = workspaceId)
  output <- .prometheusservice$delete_rule_groups_namespace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$delete_rule_groups_namespace <- prometheusservice_delete_rule_groups_namespace

#' Deletes an AMP workspace
#'
#' @description
#' Deletes an AMP workspace.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/delete_workspace.html](https://paws-r.github.io/docs/prometheusservice/delete_workspace.html) for full documentation.
#'
#' @param clientToken Optional, unique, case-sensitive, user-provided identifier to ensure the
#' idempotency of the request.
#' @param workspaceId &#91;required&#93; The ID of the workspace to delete.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_delete_workspace
prometheusservice_delete_workspace <- function(clientToken = NULL, workspaceId) {
  op <- new_operation(
    name = "DeleteWorkspace",
    http_method = "DELETE",
    http_path = "/workspaces/{workspaceId}",
    paginator = list()
  )
  input <- .prometheusservice$delete_workspace_input(clientToken = clientToken, workspaceId = workspaceId)
  output <- .prometheusservice$delete_workspace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$delete_workspace <- prometheusservice_delete_workspace

#' Describes an alert manager definition
#'
#' @description
#' Describes an alert manager definition.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/describe_alert_manager_definition.html](https://paws-r.github.io/docs/prometheusservice/describe_alert_manager_definition.html) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to describe.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_describe_alert_manager_definition
prometheusservice_describe_alert_manager_definition <- function(workspaceId) {
  op <- new_operation(
    name = "DescribeAlertManagerDefinition",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/alertmanager/definition",
    paginator = list()
  )
  input <- .prometheusservice$describe_alert_manager_definition_input(workspaceId = workspaceId)
  output <- .prometheusservice$describe_alert_manager_definition_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$describe_alert_manager_definition <- prometheusservice_describe_alert_manager_definition

#' Describe a rule groups namespace
#'
#' @description
#' Describe a rule groups namespace.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/describe_rule_groups_namespace.html](https://paws-r.github.io/docs/prometheusservice/describe_rule_groups_namespace.html) for full documentation.
#'
#' @param name &#91;required&#93; The rule groups namespace.
#' @param workspaceId &#91;required&#93; The ID of the workspace to describe.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_describe_rule_groups_namespace
prometheusservice_describe_rule_groups_namespace <- function(name, workspaceId) {
  op <- new_operation(
    name = "DescribeRuleGroupsNamespace",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/rulegroupsnamespaces/{name}",
    paginator = list()
  )
  input <- .prometheusservice$describe_rule_groups_namespace_input(name = name, workspaceId = workspaceId)
  output <- .prometheusservice$describe_rule_groups_namespace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$describe_rule_groups_namespace <- prometheusservice_describe_rule_groups_namespace

#' Describes an existing AMP workspace
#'
#' @description
#' Describes an existing AMP workspace.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/describe_workspace.html](https://paws-r.github.io/docs/prometheusservice/describe_workspace.html) for full documentation.
#'
#' @param workspaceId &#91;required&#93; The ID of the workspace to describe.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_describe_workspace
prometheusservice_describe_workspace <- function(workspaceId) {
  op <- new_operation(
    name = "DescribeWorkspace",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}",
    paginator = list()
  )
  input <- .prometheusservice$describe_workspace_input(workspaceId = workspaceId)
  output <- .prometheusservice$describe_workspace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$describe_workspace <- prometheusservice_describe_workspace

#' Lists rule groups namespaces
#'
#' @description
#' Lists rule groups namespaces.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/list_rule_groups_namespaces.html](https://paws-r.github.io/docs/prometheusservice/list_rule_groups_namespaces.html) for full documentation.
#'
#' @param maxResults Maximum results to return in response (default=100, maximum=1000).
#' @param name Optional filter for rule groups namespace name. Only the rule groups
#' namespace that begin with this value will be returned.
#' @param nextToken Pagination token to request the next page in a paginated list. This
#' token is obtained from the output of the previous
#' ListRuleGroupsNamespaces request.
#' @param workspaceId &#91;required&#93; The ID of the workspace.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_list_rule_groups_namespaces
prometheusservice_list_rule_groups_namespaces <- function(maxResults = NULL, name = NULL, nextToken = NULL, workspaceId) {
  op <- new_operation(
    name = "ListRuleGroupsNamespaces",
    http_method = "GET",
    http_path = "/workspaces/{workspaceId}/rulegroupsnamespaces",
    paginator = list()
  )
  input <- .prometheusservice$list_rule_groups_namespaces_input(maxResults = maxResults, name = name, nextToken = nextToken, workspaceId = workspaceId)
  output <- .prometheusservice$list_rule_groups_namespaces_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$list_rule_groups_namespaces <- prometheusservice_list_rule_groups_namespaces

#' Lists the tags you have assigned to the resource
#'
#' @description
#' Lists the tags you have assigned to the resource.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/list_tags_for_resource.html](https://paws-r.github.io/docs/prometheusservice/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_list_tags_for_resource
prometheusservice_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .prometheusservice$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .prometheusservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$list_tags_for_resource <- prometheusservice_list_tags_for_resource

#' Lists all AMP workspaces, including workspaces being created or deleted
#'
#' @description
#' Lists all AMP workspaces, including workspaces being created or deleted.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/list_workspaces.html](https://paws-r.github.io/docs/prometheusservice/list_workspaces.html) for full documentation.
#'
#' @param alias Optional filter for workspace alias. Only the workspaces with aliases
#' that begin with this value will be returned.
#' @param maxResults Maximum results to return in response (default=100, maximum=1000).
#' @param nextToken Pagination token to request the next page in a paginated list. This
#' token is obtained from the output of the previous ListWorkspaces
#' request.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_list_workspaces
prometheusservice_list_workspaces <- function(alias = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListWorkspaces",
    http_method = "GET",
    http_path = "/workspaces",
    paginator = list()
  )
  input <- .prometheusservice$list_workspaces_input(alias = alias, maxResults = maxResults, nextToken = nextToken)
  output <- .prometheusservice$list_workspaces_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$list_workspaces <- prometheusservice_list_workspaces

#' Update an alert manager definition
#'
#' @description
#' Update an alert manager definition.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/put_alert_manager_definition.html](https://paws-r.github.io/docs/prometheusservice/put_alert_manager_definition.html) for full documentation.
#'
#' @param clientToken Optional, unique, case-sensitive, user-provided identifier to ensure the
#' idempotency of the request.
#' @param data &#91;required&#93; The alert manager definition data.
#' @param workspaceId &#91;required&#93; The ID of the workspace in which to update the alert manager definition.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_put_alert_manager_definition
prometheusservice_put_alert_manager_definition <- function(clientToken = NULL, data, workspaceId) {
  op <- new_operation(
    name = "PutAlertManagerDefinition",
    http_method = "PUT",
    http_path = "/workspaces/{workspaceId}/alertmanager/definition",
    paginator = list()
  )
  input <- .prometheusservice$put_alert_manager_definition_input(clientToken = clientToken, data = data, workspaceId = workspaceId)
  output <- .prometheusservice$put_alert_manager_definition_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$put_alert_manager_definition <- prometheusservice_put_alert_manager_definition

#' Update a rule groups namespace
#'
#' @description
#' Update a rule groups namespace.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/put_rule_groups_namespace.html](https://paws-r.github.io/docs/prometheusservice/put_rule_groups_namespace.html) for full documentation.
#'
#' @param clientToken Optional, unique, case-sensitive, user-provided identifier to ensure the
#' idempotency of the request.
#' @param data &#91;required&#93; The namespace data that define the rule groups.
#' @param name &#91;required&#93; The rule groups namespace name.
#' @param workspaceId &#91;required&#93; The ID of the workspace in which to update the rule group namespace.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_put_rule_groups_namespace
prometheusservice_put_rule_groups_namespace <- function(clientToken = NULL, data, name, workspaceId) {
  op <- new_operation(
    name = "PutRuleGroupsNamespace",
    http_method = "PUT",
    http_path = "/workspaces/{workspaceId}/rulegroupsnamespaces/{name}",
    paginator = list()
  )
  input <- .prometheusservice$put_rule_groups_namespace_input(clientToken = clientToken, data = data, name = name, workspaceId = workspaceId)
  output <- .prometheusservice$put_rule_groups_namespace_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$put_rule_groups_namespace <- prometheusservice_put_rule_groups_namespace

#' Creates tags for the specified resource
#'
#' @description
#' Creates tags for the specified resource.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/tag_resource.html](https://paws-r.github.io/docs/prometheusservice/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource.
#' @param tags &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname prometheusservice_tag_resource
prometheusservice_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .prometheusservice$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .prometheusservice$tag_resource_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$tag_resource <- prometheusservice_tag_resource

#' Deletes tags from the specified resource
#'
#' @description
#' Deletes tags from the specified resource.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/untag_resource.html](https://paws-r.github.io/docs/prometheusservice/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource.
#' @param tagKeys &#91;required&#93; One or more tag keys
#'
#' @keywords internal
#'
#' @rdname prometheusservice_untag_resource
prometheusservice_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .prometheusservice$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .prometheusservice$untag_resource_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$untag_resource <- prometheusservice_untag_resource

#' Updates an AMP workspace alias
#'
#' @description
#' Updates an AMP workspace alias.
#'
#' See [https://paws-r.github.io/docs/prometheusservice/update_workspace_alias.html](https://paws-r.github.io/docs/prometheusservice/update_workspace_alias.html) for full documentation.
#'
#' @param alias The new alias of the workspace.
#' @param clientToken Optional, unique, case-sensitive, user-provided identifier to ensure the
#' idempotency of the request.
#' @param workspaceId &#91;required&#93; The ID of the workspace being updated.
#'
#' @keywords internal
#'
#' @rdname prometheusservice_update_workspace_alias
prometheusservice_update_workspace_alias <- function(alias = NULL, clientToken = NULL, workspaceId) {
  op <- new_operation(
    name = "UpdateWorkspaceAlias",
    http_method = "POST",
    http_path = "/workspaces/{workspaceId}/alias",
    paginator = list()
  )
  input <- .prometheusservice$update_workspace_alias_input(alias = alias, clientToken = clientToken, workspaceId = workspaceId)
  output <- .prometheusservice$update_workspace_alias_output()
  config <- get_config()
  svc <- .prometheusservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.prometheusservice$operations$update_workspace_alias <- prometheusservice_update_workspace_alias
