% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_list_insights_metric_data}
\alias{cloudtrail_list_insights_metric_data}
\title{Returns Insights metrics data for trails that have enabled Insights}
\usage{
cloudtrail_list_insights_metric_data(
  EventSource,
  EventName,
  InsightType,
  ErrorCode = NULL,
  StartTime = NULL,
  EndTime = NULL,
  Period = NULL,
  DataType = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{EventSource}{[required] The Amazon Web Services service to which the request was made, such as
\code{iam.amazonaws.com} or \code{s3.amazonaws.com}.}

\item{EventName}{[required] The name of the event, typically the Amazon Web Services API on which
unusual levels of activity were recorded.}

\item{InsightType}{[required] The type of CloudTrail Insights event, which is either
\code{ApiCallRateInsight} or \code{ApiErrorRateInsight}. The \code{ApiCallRateInsight}
Insights type analyzes write-only management API calls that are
aggregated per minute against a baseline API call volume. The
\code{ApiErrorRateInsight} Insights type analyzes management API calls that
result in error codes.}

\item{ErrorCode}{Conditionally required if the \code{InsightType} parameter is set to
\code{ApiErrorRateInsight}.

If returning metrics for the \code{ApiErrorRateInsight} Insights type, this
is the error to retrieve data for. For example, \code{AccessDenied}.}

\item{StartTime}{Specifies, in UTC, the start time for time-series data. The value
specified is inclusive; results include data points with the specified
time stamp.

The default is 90 days before the time of request.}

\item{EndTime}{Specifies, in UTC, the end time for time-series data. The value
specified is exclusive; results include data points up to the specified
time stamp.

The default is the time of request.}

\item{Period}{Granularity of data to retrieve, in seconds. Valid values are \code{60},
\code{300}, and \code{3600}. If you specify any other value, you will get an
error. The default is 3600 seconds.}

\item{DataType}{Type of data points to return. Valid values are \code{NonZeroData} and
\code{FillWithZeros}. The default is \code{NonZeroData}.}

\item{MaxResults}{The maximum number of data points to return. Valid values are integers
from 1 to 21600. The default value is 21600.}

\item{NextToken}{Returned if all datapoints can't be returned in a single call. For
example, due to reaching \code{MaxResults}.

Add this parameter to the request to continue retrieving results
starting from the last evaluated point.}
}
\description{
Returns Insights metrics data for trails that have enabled Insights. The request must include the \code{EventSource}, \code{EventName}, and \code{InsightType} parameters.

See \url{https://www.paws-r-sdk.com/docs/cloudtrail_list_insights_metric_data/} for full documentation.
}
\keyword{internal}
