% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/managedgrafana_operations.R
\name{managedgrafana_create_workspace_service_account_token}
\alias{managedgrafana_create_workspace_service_account_token}
\title{Creates a token that can be used to authenticate and authorize Grafana
HTTP API operations for the given workspace service account}
\usage{
managedgrafana_create_workspace_service_account_token(
  name,
  secondsToLive,
  serviceAccountId,
  workspaceId
)
}
\arguments{
\item{name}{[required] A name for the token to create.}

\item{secondsToLive}{[required] Sets how long the token will be valid, in seconds. You can set the time
up to 30 days in the future.}

\item{serviceAccountId}{[required] The ID of the service account for which to create a token.}

\item{workspaceId}{[required] The ID of the workspace the service account resides within.}
}
\description{
Creates a token that can be used to authenticate and authorize Grafana HTTP API operations for the given \href{https://docs.aws.amazon.com/grafana/latest/userguide/service-accounts.html}{workspace service account}. The service account acts as a user for the API operations, and defines the permissions that are used by the API.

See \url{https://www.paws-r-sdk.com/docs/managedgrafana_create_workspace_service_account_token/} for full documentation.
}
\keyword{internal}
