% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_list_resolver_query_log_config_associations}
\alias{route53resolver_list_resolver_query_log_config_associations}
\title{Lists information about associations between Amazon VPCs and query
logging configurations}
\usage{
route53resolver_list_resolver_query_log_config_associations(
  MaxResults = NULL,
  NextToken = NULL,
  Filters = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{MaxResults}{The maximum number of query logging associations that you want to return
in the response to a
\code{\link[=route53resolver_list_resolver_query_log_config_associations]{list_resolver_query_log_config_associations}}
request. If you don't specify a value for \code{MaxResults}, Resolver returns
up to 100 query logging associations.}

\item{NextToken}{For the first
\code{\link[=route53resolver_list_resolver_query_log_config_associations]{list_resolver_query_log_config_associations}}
request, omit this value.

If there are more than \code{MaxResults} query logging associations that
match the values that you specify for \code{Filters}, you can submit another
\code{\link[=route53resolver_list_resolver_query_log_config_associations]{list_resolver_query_log_config_associations}}
request to get the next group of associations. In the next request,
specify the value of \code{NextToken} from the previous response.}

\item{Filters}{An optional specification to return a subset of query logging
associations.

If you submit a second or subsequent
\code{\link[=route53resolver_list_resolver_query_log_config_associations]{list_resolver_query_log_config_associations}}
request and specify the \code{NextToken} parameter, you must use the same
values for \code{Filters}, if any, as in the previous request.}

\item{SortBy}{The element that you want Resolver to sort query logging associations
by.

If you submit a second or subsequent
\code{\link[=route53resolver_list_resolver_query_log_config_associations]{list_resolver_query_log_config_associations}}
request and specify the \code{NextToken} parameter, you must use the same
value for \code{SortBy}, if any, as in the previous request.

Valid values include the following elements:
\itemize{
\item \code{CreationTime}: The ID of the query logging association.
\item \code{Error}: If the value of \code{Status} is \code{FAILED}, the value of \code{Error}
indicates the cause:
\itemize{
\item \code{DESTINATION_NOT_FOUND}: The specified destination (for example,
an Amazon S3 bucket) was deleted.
\item \code{ACCESS_DENIED}: Permissions don't allow sending logs to the
destination.
}

If \code{Status} is a value other than \code{FAILED}, \code{ERROR} is null.
\item \code{Id}: The ID of the query logging association
\item \code{ResolverQueryLogConfigId}: The ID of the query logging
configuration
\item \code{ResourceId}: The ID of the VPC that is associated with the query
logging configuration
\item \code{Status}: The current status of the configuration. Valid values
include the following:
\itemize{
\item \code{CREATING}: Resolver is creating an association between an
Amazon VPC and a query logging configuration.
\item \code{CREATED}: The association between an Amazon VPC and a query
logging configuration was successfully created. Resolver is
logging queries that originate in the specified VPC.
\item \code{DELETING}: Resolver is deleting this query logging association.
\item \code{FAILED}: Resolver either couldn't create or couldn't delete the
query logging association. Here are two common causes:
\itemize{
\item The specified destination (for example, an Amazon S3 bucket)
was deleted.
\item Permissions don't allow sending logs to the destination.
}
}
}}

\item{SortOrder}{If you specified a value for \code{SortBy}, the order that you want query
logging associations to be listed in, \code{ASCENDING} or \code{DESCENDING}.

If you submit a second or subsequent
\code{\link[=route53resolver_list_resolver_query_log_config_associations]{list_resolver_query_log_config_associations}}
request and specify the \code{NextToken} parameter, you must use the same
value for \code{SortOrder}, if any, as in the previous request.}
}
\description{
Lists information about associations between Amazon VPCs and query logging configurations.

See \url{https://www.paws-r-sdk.com/docs/route53resolver_list_resolver_query_log_config_associations/} for full documentation.
}
\keyword{internal}
