# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include route53profiles_service.R
NULL

#' Associates a Route 53 Profiles profile with a VPC
#'
#' @description
#' Associates a Route 53 Profiles profile with a VPC. A VPC can have only one Profile associated with it, but a Profile can be associated with 1000 of VPCs (and you can request a higher quota). For more information, see <https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-entities>.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_associate_profile/](https://www.paws-r-sdk.com/docs/route53profiles_associate_profile/) for full documentation.
#'
#' @param Name &#91;required&#93; A name for the association.
#' @param ProfileId &#91;required&#93; ID of the Profile.
#' @param ResourceId &#91;required&#93; The ID of the VPC.
#' @param Tags A list of the tag keys and values that you want to identify the Profile
#' association.
#'
#' @keywords internal
#'
#' @rdname route53profiles_associate_profile
route53profiles_associate_profile <- function(Name, ProfileId, ResourceId, Tags = NULL) {
  op <- new_operation(
    name = "AssociateProfile",
    http_method = "POST",
    http_path = "/profileassociation",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$associate_profile_input(Name = Name, ProfileId = ProfileId, ResourceId = ResourceId, Tags = Tags)
  output <- .route53profiles$associate_profile_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$associate_profile <- route53profiles_associate_profile

#' Associates a DNS reource configuration to a Route 53 Profile
#'
#' @description
#' Associates a DNS reource configuration to a Route 53 Profile.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_associate_resource_to_profile/](https://www.paws-r-sdk.com/docs/route53profiles_associate_resource_to_profile/) for full documentation.
#'
#' @param Name &#91;required&#93; Name for the resource association.
#' @param ProfileId &#91;required&#93; ID of the Profile.
#' @param ResourceArn &#91;required&#93; Amazon resource number, ARN, of the DNS resource.
#' @param ResourceProperties If you are adding a DNS Firewall rule group, include also a priority.
#' The priority indicates the processing order for the rule groups,
#' starting with the priority assinged the lowest value.
#' 
#' The allowed values for priority are between 100 and 9900.
#'
#' @keywords internal
#'
#' @rdname route53profiles_associate_resource_to_profile
route53profiles_associate_resource_to_profile <- function(Name, ProfileId, ResourceArn, ResourceProperties = NULL) {
  op <- new_operation(
    name = "AssociateResourceToProfile",
    http_method = "POST",
    http_path = "/profileresourceassociation",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$associate_resource_to_profile_input(Name = Name, ProfileId = ProfileId, ResourceArn = ResourceArn, ResourceProperties = ResourceProperties)
  output <- .route53profiles$associate_resource_to_profile_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$associate_resource_to_profile <- route53profiles_associate_resource_to_profile

#' Creates an empty Route 53 Profile
#'
#' @description
#' Creates an empty Route 53 Profile.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_create_profile/](https://www.paws-r-sdk.com/docs/route53profiles_create_profile/) for full documentation.
#'
#' @param ClientToken &#91;required&#93; `ClientToken` is an idempotency token that ensures a call to
#' [`create_profile`][route53profiles_create_profile] completes only once.
#' You choose the value to pass. For example, an issue might prevent you
#' from getting a response from
#' [`create_profile`][route53profiles_create_profile]. In this case, safely
#' retry your call to [`create_profile`][route53profiles_create_profile] by
#' using the same [`create_profile`][route53profiles_create_profile]
#' parameter value.
#' @param Name &#91;required&#93; A name for the Profile.
#' @param Tags A list of the tag keys and values that you want to associate with the
#' Route 53 Profile.
#'
#' @keywords internal
#'
#' @rdname route53profiles_create_profile
route53profiles_create_profile <- function(ClientToken, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateProfile",
    http_method = "POST",
    http_path = "/profile",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$create_profile_input(ClientToken = ClientToken, Name = Name, Tags = Tags)
  output <- .route53profiles$create_profile_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$create_profile <- route53profiles_create_profile

#' Deletes the specified Route 53 Profile
#'
#' @description
#' Deletes the specified Route 53 Profile. Before you can delete a profile, you must first disassociate it from all VPCs.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_delete_profile/](https://www.paws-r-sdk.com/docs/route53profiles_delete_profile/) for full documentation.
#'
#' @param ProfileId &#91;required&#93; The ID of the Profile that you want to delete.
#'
#' @keywords internal
#'
#' @rdname route53profiles_delete_profile
route53profiles_delete_profile <- function(ProfileId) {
  op <- new_operation(
    name = "DeleteProfile",
    http_method = "DELETE",
    http_path = "/profile/{ProfileId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$delete_profile_input(ProfileId = ProfileId)
  output <- .route53profiles$delete_profile_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$delete_profile <- route53profiles_delete_profile

#' Dissociates a specified Route 53 Profile from the specified VPC
#'
#' @description
#' Dissociates a specified Route 53 Profile from the specified VPC.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_disassociate_profile/](https://www.paws-r-sdk.com/docs/route53profiles_disassociate_profile/) for full documentation.
#'
#' @param ProfileId &#91;required&#93; ID of the Profile.
#' @param ResourceId &#91;required&#93; The ID of the VPC.
#'
#' @keywords internal
#'
#' @rdname route53profiles_disassociate_profile
route53profiles_disassociate_profile <- function(ProfileId, ResourceId) {
  op <- new_operation(
    name = "DisassociateProfile",
    http_method = "DELETE",
    http_path = "/profileassociation/Profileid/{ProfileId}/resourceid/{ResourceId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$disassociate_profile_input(ProfileId = ProfileId, ResourceId = ResourceId)
  output <- .route53profiles$disassociate_profile_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$disassociate_profile <- route53profiles_disassociate_profile

#' Dissoaciated a specified resource, from the Route 53 Profile
#'
#' @description
#' Dissoaciated a specified resource, from the Route 53 Profile.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_disassociate_resource_from_profile/](https://www.paws-r-sdk.com/docs/route53profiles_disassociate_resource_from_profile/) for full documentation.
#'
#' @param ProfileId &#91;required&#93; The ID of the Profile.
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname route53profiles_disassociate_resource_from_profile
route53profiles_disassociate_resource_from_profile <- function(ProfileId, ResourceArn) {
  op <- new_operation(
    name = "DisassociateResourceFromProfile",
    http_method = "DELETE",
    http_path = "/profileresourceassociation/profileid/{ProfileId}/resourcearn/{ResourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$disassociate_resource_from_profile_input(ProfileId = ProfileId, ResourceArn = ResourceArn)
  output <- .route53profiles$disassociate_resource_from_profile_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$disassociate_resource_from_profile <- route53profiles_disassociate_resource_from_profile

#' Returns information about a specified Route 53 Profile, such as whether
#' whether the Profile is shared, and the current status of the Profile
#'
#' @description
#' Returns information about a specified Route 53 Profile, such as whether whether the Profile is shared, and the current status of the Profile.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_get_profile/](https://www.paws-r-sdk.com/docs/route53profiles_get_profile/) for full documentation.
#'
#' @param ProfileId &#91;required&#93; ID of the Profile.
#'
#' @keywords internal
#'
#' @rdname route53profiles_get_profile
route53profiles_get_profile <- function(ProfileId) {
  op <- new_operation(
    name = "GetProfile",
    http_method = "GET",
    http_path = "/profile/{ProfileId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$get_profile_input(ProfileId = ProfileId)
  output <- .route53profiles$get_profile_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$get_profile <- route53profiles_get_profile

#' Retrieves a Route 53 Profile association for a VPC
#'
#' @description
#' Retrieves a Route 53 Profile association for a VPC. A VPC can have only one Profile association, but a Profile can be associated with up to 5000 VPCs.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_get_profile_association/](https://www.paws-r-sdk.com/docs/route53profiles_get_profile_association/) for full documentation.
#'
#' @param ProfileAssociationId &#91;required&#93; The identifier of the association you want to get information about.
#'
#' @keywords internal
#'
#' @rdname route53profiles_get_profile_association
route53profiles_get_profile_association <- function(ProfileAssociationId) {
  op <- new_operation(
    name = "GetProfileAssociation",
    http_method = "GET",
    http_path = "/profileassociation/{ProfileAssociationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$get_profile_association_input(ProfileAssociationId = ProfileAssociationId)
  output <- .route53profiles$get_profile_association_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$get_profile_association <- route53profiles_get_profile_association

#' Returns information about a specified Route 53 Profile resource
#' association
#'
#' @description
#' Returns information about a specified Route 53 Profile resource association.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_get_profile_resource_association/](https://www.paws-r-sdk.com/docs/route53profiles_get_profile_resource_association/) for full documentation.
#'
#' @param ProfileResourceAssociationId &#91;required&#93; The ID of the profile resource association that you want to get
#' information about.
#'
#' @keywords internal
#'
#' @rdname route53profiles_get_profile_resource_association
route53profiles_get_profile_resource_association <- function(ProfileResourceAssociationId) {
  op <- new_operation(
    name = "GetProfileResourceAssociation",
    http_method = "GET",
    http_path = "/profileresourceassociation/{ProfileResourceAssociationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$get_profile_resource_association_input(ProfileResourceAssociationId = ProfileResourceAssociationId)
  output <- .route53profiles$get_profile_resource_association_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$get_profile_resource_association <- route53profiles_get_profile_resource_association

#' Lists all the VPCs that the specified Route 53 Profile is associated
#' with
#'
#' @description
#' Lists all the VPCs that the specified Route 53 Profile is associated with.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_list_profile_associations/](https://www.paws-r-sdk.com/docs/route53profiles_list_profile_associations/) for full documentation.
#'
#' @param MaxResults The maximum number of objects that you want to return for this request.
#' If more objects are available, in the response, a `NextToken` value,
#' which you can use in a subsequent call to get the next batch of objects,
#' is provided.
#' 
#' If you don't specify a value for `MaxResults`, up to 100 objects are
#' returned.
#' @param NextToken For the first call to this list request, omit this value.
#' 
#' When you request a list of objects, at most the number of objects
#' specified by `MaxResults` is returned. If more objects are available for
#' retrieval, a `NextToken` value is returned in the response. To retrieve
#' the next batch of objects, use the token that was returned for the prior
#' request in your next request.
#' @param ProfileId ID of the Profile.
#' @param ResourceId ID of the VPC.
#'
#' @keywords internal
#'
#' @rdname route53profiles_list_profile_associations
route53profiles_list_profile_associations <- function(MaxResults = NULL, NextToken = NULL, ProfileId = NULL, ResourceId = NULL) {
  op <- new_operation(
    name = "ListProfileAssociations",
    http_method = "GET",
    http_path = "/profileassociations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ProfileAssociations"),
    stream_api = FALSE
  )
  input <- .route53profiles$list_profile_associations_input(MaxResults = MaxResults, NextToken = NextToken, ProfileId = ProfileId, ResourceId = ResourceId)
  output <- .route53profiles$list_profile_associations_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$list_profile_associations <- route53profiles_list_profile_associations

#' Lists all the resource associations for the specified Route 53 Profile
#'
#' @description
#' Lists all the resource associations for the specified Route 53 Profile.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_list_profile_resource_associations/](https://www.paws-r-sdk.com/docs/route53profiles_list_profile_resource_associations/) for full documentation.
#'
#' @param MaxResults The maximum number of objects that you want to return for this request.
#' If more objects are available, in the response, a `NextToken` value,
#' which you can use in a subsequent call to get the next batch of objects,
#' is provided.
#' 
#' If you don't specify a value for `MaxResults`, up to 100 objects are
#' returned.
#' @param NextToken For the first call to this list request, omit this value.
#' 
#' When you request a list of objects, at most the number of objects
#' specified by `MaxResults` is returned. If more objects are available for
#' retrieval, a `NextToken` value is returned in the response. To retrieve
#' the next batch of objects, use the token that was returned for the prior
#' request in your next request.
#' @param ProfileId &#91;required&#93; The ID of the Profile.
#' @param ResourceType ID of a resource if you want information on only one type.
#'
#' @keywords internal
#'
#' @rdname route53profiles_list_profile_resource_associations
route53profiles_list_profile_resource_associations <- function(MaxResults = NULL, NextToken = NULL, ProfileId, ResourceType = NULL) {
  op <- new_operation(
    name = "ListProfileResourceAssociations",
    http_method = "GET",
    http_path = "/profileresourceassociations/profileid/{ProfileId}",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ProfileResourceAssociations"),
    stream_api = FALSE
  )
  input <- .route53profiles$list_profile_resource_associations_input(MaxResults = MaxResults, NextToken = NextToken, ProfileId = ProfileId, ResourceType = ResourceType)
  output <- .route53profiles$list_profile_resource_associations_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$list_profile_resource_associations <- route53profiles_list_profile_resource_associations

#' Lists all the Route 53 Profiles associated with your Amazon Web Services
#' account
#'
#' @description
#' Lists all the Route 53 Profiles associated with your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_list_profiles/](https://www.paws-r-sdk.com/docs/route53profiles_list_profiles/) for full documentation.
#'
#' @param MaxResults The maximum number of objects that you want to return for this request.
#' If more objects are available, in the response, a `NextToken` value,
#' which you can use in a subsequent call to get the next batch of objects,
#' is provided.
#' 
#' If you don't specify a value for `MaxResults`, up to 100 objects are
#' returned.
#' @param NextToken For the first call to this list request, omit this value.
#' 
#' When you request a list of objects, at most the number of objects
#' specified by `MaxResults` is returned. If more objects are available for
#' retrieval, a `NextToken` value is returned in the response. To retrieve
#' the next batch of objects, use the token that was returned for the prior
#' request in your next request.
#'
#' @keywords internal
#'
#' @rdname route53profiles_list_profiles
route53profiles_list_profiles <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListProfiles",
    http_method = "GET",
    http_path = "/profiles",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ProfileSummaries"),
    stream_api = FALSE
  )
  input <- .route53profiles$list_profiles_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53profiles$list_profiles_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$list_profiles <- route53profiles_list_profiles

#' Lists the tags that you associated with the specified resource
#'
#' @description
#' Lists the tags that you associated with the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/route53profiles_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that you want to list
#' the tags for.
#'
#' @keywords internal
#'
#' @rdname route53profiles_list_tags_for_resource
route53profiles_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .route53profiles$list_tags_for_resource_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$list_tags_for_resource <- route53profiles_list_tags_for_resource

#' Adds one or more tags to a specified resource
#'
#' @description
#' Adds one or more tags to a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_tag_resource/](https://www.paws-r-sdk.com/docs/route53profiles_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that you want to add
#' tags to.
#' @param Tags &#91;required&#93; The tags that you want to add to the specified resource.
#'
#' @keywords internal
#'
#' @rdname route53profiles_tag_resource
route53profiles_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .route53profiles$tag_resource_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$tag_resource <- route53profiles_tag_resource

#' Removes one or more tags from a specified resource
#'
#' @description
#' Removes one or more tags from a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_untag_resource/](https://www.paws-r-sdk.com/docs/route53profiles_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that you want to remove
#' tags from.
#' @param TagKeys &#91;required&#93; The tags that you want to remove to the specified resource.
#'
#' @keywords internal
#'
#' @rdname route53profiles_untag_resource
route53profiles_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .route53profiles$untag_resource_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$untag_resource <- route53profiles_untag_resource

#' Updates the specified Route 53 Profile resourse association
#'
#' @description
#' Updates the specified Route 53 Profile resourse association.
#'
#' See [https://www.paws-r-sdk.com/docs/route53profiles_update_profile_resource_association/](https://www.paws-r-sdk.com/docs/route53profiles_update_profile_resource_association/) for full documentation.
#'
#' @param Name Name of the resource association.
#' @param ProfileResourceAssociationId &#91;required&#93; ID of the resource association.
#' @param ResourceProperties If you are adding a DNS Firewall rule group, include also a priority.
#' The priority indicates the processing order for the rule groups,
#' starting with the priority assinged the lowest value.
#' 
#' The allowed values for priority are between 100 and 9900.
#'
#' @keywords internal
#'
#' @rdname route53profiles_update_profile_resource_association
route53profiles_update_profile_resource_association <- function(Name = NULL, ProfileResourceAssociationId, ResourceProperties = NULL) {
  op <- new_operation(
    name = "UpdateProfileResourceAssociation",
    http_method = "PATCH",
    http_path = "/profileresourceassociation/{ProfileResourceAssociationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .route53profiles$update_profile_resource_association_input(Name = Name, ProfileResourceAssociationId = ProfileResourceAssociationId, ResourceProperties = ResourceProperties)
  output <- .route53profiles$update_profile_resource_association_output()
  config <- get_config()
  svc <- .route53profiles$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53profiles$operations$update_profile_resource_association <- route53profiles_update_profile_resource_association
