% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_associate_resource_share_permission}
\alias{ram_associate_resource_share_permission}
\title{Associates a permission with a resource share}
\usage{
ram_associate_resource_share_permission(resourceShareArn, permissionArn,
  replace, clientToken)
}
\arguments{
\item{resourceShareArn}{[required] The Amazon Resource Name (ARN) of the resource share.}

\item{permissionArn}{[required] The ARN of the AWS RAM permission to associate with the resource share.}

\item{replace}{Indicates whether the permission should replace the permissions that are
currently associated with the resource share. Use \code{true} to replace the
current permissions. Use \code{false} to add the permission to the current
permission.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\description{
Associates a permission with a resource share.
}
\section{Request syntax}{
\preformatted{svc$associate_resource_share_permission(
  resourceShareArn = "string",
  permissionArn = "string",
  replace = TRUE|FALSE,
  clientToken = "string"
)
}
}

\keyword{internal}
