% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_role_policies}
\alias{iam_list_role_policies}
\title{Lists the names of the inline policies that are embedded in the
specified IAM role}
\usage{
iam_list_role_policies(RoleName, Marker, MaxItems)
}
\arguments{
\item{RoleName}{[required] The name of the role to list policies for.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\value{
A list with the following syntax:\preformatted{list(
  PolicyNames = list(
    "string"
  ),
  IsTruncated = TRUE|FALSE,
  Marker = "string"
)
}
}
\description{
Lists the names of the inline policies that are embedded in the
specified IAM role.

An IAM role can also have managed policies attached to it. To list the
managed policies that are attached to a role, use
\code{\link[=iam_list_attached_role_policies]{list_attached_role_policies}}. For
more information about policies, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.

You can paginate the results using the \code{MaxItems} and \code{Marker}
parameters. If there are no inline policies embedded with the specified
role, the operation returns an empty list.
}
\section{Request syntax}{
\preformatted{svc$list_role_policies(
  RoleName = "string",
  Marker = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
