# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Cognito Identity
#'
#' @description
#' Amazon Cognito Federated Identities
#' 
#' Amazon Cognito Federated Identities is a web service that delivers
#' scoped temporary credentials to mobile devices and other untrusted
#' environments. It uniquely identifies a device and supplies the user with
#' a consistent identity over the lifetime of an application.
#' 
#' Using Amazon Cognito Federated Identities, you can enable authentication
#' with one or more third-party identity providers (Facebook, Google, or
#' Login with Amazon) or an Amazon Cognito user pool, and you can also
#' choose to support unauthenticated access from your app. Cognito delivers
#' a unique identifier for each user and acts as an OpenID token provider
#' trusted by AWS Security Token Service (STS) to access temporary,
#' limited-privilege AWS credentials.
#' 
#' For a description of the authentication flow from the Amazon Cognito
#' Developer Guide see [Authentication
#' Flow](https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html).
#' 
#' For more information see [Amazon Cognito Federated
#' Identities](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- cognitoidentity(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- cognitoidentity()
#' svc$create_identity_pool(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cognitoidentity_create_identity_pool]{create_identity_pool} \tab Creates a new identity pool\cr
#'  \link[=cognitoidentity_delete_identities]{delete_identities} \tab Deletes identities from an identity pool\cr
#'  \link[=cognitoidentity_delete_identity_pool]{delete_identity_pool} \tab Deletes an identity pool\cr
#'  \link[=cognitoidentity_describe_identity]{describe_identity} \tab Returns metadata related to the given identity, including when the identity was created and any associated linked logins\cr
#'  \link[=cognitoidentity_describe_identity_pool]{describe_identity_pool} \tab Gets details about a particular identity pool, including the pool name, ID description, creation date, and current number of users\cr
#'  \link[=cognitoidentity_get_credentials_for_identity]{get_credentials_for_identity} \tab Returns credentials for the provided identity ID\cr
#'  \link[=cognitoidentity_get_id]{get_id} \tab Generates (or retrieves) a Cognito ID\cr
#'  \link[=cognitoidentity_get_identity_pool_roles]{get_identity_pool_roles} \tab Gets the roles for an identity pool\cr
#'  \link[=cognitoidentity_get_open_id_token]{get_open_id_token} \tab Gets an OpenID token, using a known Cognito ID\cr
#'  \link[=cognitoidentity_get_open_id_token_for_developer_identity]{get_open_id_token_for_developer_identity} \tab Registers (or retrieves) a Cognito IdentityId and an OpenID Connect token for a user authenticated by your backend authentication process\cr
#'  \link[=cognitoidentity_list_identities]{list_identities} \tab Lists the identities in an identity pool\cr
#'  \link[=cognitoidentity_list_identity_pools]{list_identity_pools} \tab Lists all of the Cognito identity pools registered for your account\cr
#'  \link[=cognitoidentity_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags that are assigned to an Amazon Cognito identity pool\cr
#'  \link[=cognitoidentity_lookup_developer_identity]{lookup_developer_identity} \tab Retrieves the IdentityID associated with a DeveloperUserIdentifier or the list of DeveloperUserIdentifier values associated with an IdentityId for an existing identity\cr
#'  \link[=cognitoidentity_merge_developer_identities]{merge_developer_identities} \tab Merges two users having different IdentityIds, existing in the same identity pool, and identified by the same developer provider\cr
#'  \link[=cognitoidentity_set_identity_pool_roles]{set_identity_pool_roles} \tab Sets the roles for an identity pool\cr
#'  \link[=cognitoidentity_tag_resource]{tag_resource} \tab Assigns a set of tags to an Amazon Cognito identity pool\cr
#'  \link[=cognitoidentity_unlink_developer_identity]{unlink_developer_identity} \tab Unlinks a DeveloperUserIdentifier from an existing identity\cr
#'  \link[=cognitoidentity_unlink_identity]{unlink_identity} \tab Unlinks a federated identity from an existing account\cr
#'  \link[=cognitoidentity_untag_resource]{untag_resource} \tab Removes the specified tags from an Amazon Cognito identity pool\cr
#'  \link[=cognitoidentity_update_identity_pool]{update_identity_pool} \tab Updates an identity pool
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname cognitoidentity
#' @export
cognitoidentity <- function(config = list()) {
  svc <- .cognitoidentity$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cognitoidentity <- list()

.cognitoidentity$operations <- list()

.cognitoidentity$metadata <- list(
  service_name = "cognito-identity",
  endpoints = list("*" = list(endpoint = "cognito-identity.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cognito-identity.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "cognito-identity.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "cognito-identity.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Cognito Identity",
  api_version = "2014-06-30",
  signing_name = "cognito-identity",
  json_version = "1.1",
  target_prefix = "AWSCognitoIdentityService"
)

.cognitoidentity$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.cognitoidentity$metadata, handlers, config)
}
