% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_ssh_public_key}
\alias{iam_delete_ssh_public_key}
\title{Deletes the specified SSH public key}
\usage{
iam_delete_ssh_public_key(UserName, SSHPublicKeyId)
}
\arguments{
\item{UserName}{[required] The name of the IAM user associated with the SSH public key.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{SSHPublicKeyId}{[required] The unique identifier for the SSH public key.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
that can consist of any upper or lowercased letter or digit.}
}
\value{
An empty list.
}
\description{
Deletes the specified SSH public key.

The SSH public key deleted by this operation is used only for
authenticating the associated IAM user to an AWS CodeCommit repository.
For more information about using SSH keys to authenticate to an AWS
CodeCommit repository, see \href{https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up.html}{Set up AWS CodeCommit for SSH Connections}
in the \emph{AWS CodeCommit User Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_ssh_public_key(
  UserName = "string",
  SSHPublicKeyId = "string"
)
}
}

\keyword{internal}
