# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include securityhub_service.R
NULL

#' Accepts the invitation to be a member account and be monitored by the
#' Security Hub master account that the invitation was sent from
#'
#' Accepts the invitation to be a member account and be monitored by the
#' Security Hub master account that the invitation was sent from. When the
#' member account accepts the invitation, permission is granted to the
#' master account to view findings generated in the member account.
#'
#' @usage
#' securityhub_accept_invitation(MasterId, InvitationId)
#'
#' @param MasterId The account ID of the Security Hub master account that sent the
#' invitation.
#' @param InvitationId The ID of the invitation sent from the Security Hub master account.
#'
#' @section Request syntax:
#' ```
#' svc$accept_invitation(
#'   MasterId = "string",
#'   InvitationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_accept_invitation
securityhub_accept_invitation <- function(MasterId = NULL, InvitationId = NULL) {
  op <- new_operation(
    name = "AcceptInvitation",
    http_method = "POST",
    http_path = "/master",
    paginator = list()
  )
  input <- .securityhub$accept_invitation_input(MasterId = MasterId, InvitationId = InvitationId)
  output <- .securityhub$accept_invitation_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$accept_invitation <- securityhub_accept_invitation

#' Disables the standards specified by the provided
#' StandardsSubscriptionArns
#'
#' Disables the standards specified by the provided
#' `StandardsSubscriptionArns`. For more information, see [Standards
#' Supported in AWS Security
#' Hub](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html).
#'
#' @usage
#' securityhub_batch_disable_standards(StandardsSubscriptionArns)
#'
#' @param StandardsSubscriptionArns &#91;required&#93; The ARNs of the standards subscriptions to disable.
#'
#' @section Request syntax:
#' ```
#' svc$batch_disable_standards(
#'   StandardsSubscriptionArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_disable_standards
securityhub_batch_disable_standards <- function(StandardsSubscriptionArns) {
  op <- new_operation(
    name = "BatchDisableStandards",
    http_method = "POST",
    http_path = "/standards/deregister",
    paginator = list()
  )
  input <- .securityhub$batch_disable_standards_input(StandardsSubscriptionArns = StandardsSubscriptionArns)
  output <- .securityhub$batch_disable_standards_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_disable_standards <- securityhub_batch_disable_standards

#' Enables the standards specified by the provided standardsArn
#'
#' Enables the standards specified by the provided `standardsArn`. In this
#' release, only CIS AWS Foundations standards are supported. For more
#' information, see [Standards Supported in AWS Security
#' Hub](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html).
#'
#' @usage
#' securityhub_batch_enable_standards(StandardsSubscriptionRequests)
#'
#' @param StandardsSubscriptionRequests &#91;required&#93; The list of standards compliance checks to enable.
#' 
#' In this release, Security Hub supports only the CIS AWS Foundations
#' standard.
#' 
#' The ARN for the standard is
#' `arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0`.
#'
#' @section Request syntax:
#' ```
#' svc$batch_enable_standards(
#'   StandardsSubscriptionRequests = list(
#'     list(
#'       StandardsArn = "string",
#'       StandardsInput = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_enable_standards
securityhub_batch_enable_standards <- function(StandardsSubscriptionRequests) {
  op <- new_operation(
    name = "BatchEnableStandards",
    http_method = "POST",
    http_path = "/standards/register",
    paginator = list()
  )
  input <- .securityhub$batch_enable_standards_input(StandardsSubscriptionRequests = StandardsSubscriptionRequests)
  output <- .securityhub$batch_enable_standards_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_enable_standards <- securityhub_batch_enable_standards

#' Imports security findings generated from an integrated third-party
#' product into Security Hub
#'
#' Imports security findings generated from an integrated third-party
#' product into Security Hub. This action is requested by the integrated
#' product to import its findings into Security Hub. The maximum allowed
#' size for a finding is 240 Kb. An error is returned for any finding
#' larger than 240 Kb.
#'
#' @usage
#' securityhub_batch_import_findings(Findings)
#'
#' @param Findings &#91;required&#93; A list of findings to import. To successfully import a finding, it must
#' follow the [AWS Security Finding
#' Format](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html).
#'
#' @section Request syntax:
#' ```
#' svc$batch_import_findings(
#'   Findings = list(
#'     list(
#'       SchemaVersion = "string",
#'       Id = "string",
#'       ProductArn = "string",
#'       GeneratorId = "string",
#'       AwsAccountId = "string",
#'       Types = list(
#'         "string"
#'       ),
#'       FirstObservedAt = "string",
#'       LastObservedAt = "string",
#'       CreatedAt = "string",
#'       UpdatedAt = "string",
#'       Severity = list(
#'         Product = 123.0,
#'         Normalized = 123
#'       ),
#'       Confidence = 123,
#'       Criticality = 123,
#'       Title = "string",
#'       Description = "string",
#'       Remediation = list(
#'         Recommendation = list(
#'           Text = "string",
#'           Url = "string"
#'         )
#'       ),
#'       SourceUrl = "string",
#'       ProductFields = list(
#'         "string"
#'       ),
#'       UserDefinedFields = list(
#'         "string"
#'       ),
#'       Malware = list(
#'         list(
#'           Name = "string",
#'           Type = "ADWARE"|"BLENDED_THREAT"|"BOTNET_AGENT"|"COIN_MINER"|"EXPLOIT_KIT"|"KEYLOGGER"|"MACRO"|"POTENTIALLY_UNWANTED"|"SPYWARE"|"RANSOMWARE"|"REMOTE_ACCESS"|"ROOTKIT"|"TROJAN"|"VIRUS"|"WORM",
#'           Path = "string",
#'           State = "OBSERVED"|"REMOVAL_FAILED"|"REMOVED"
#'         )
#'       ),
#'       Network = list(
#'         Direction = "IN"|"OUT",
#'         Protocol = "string",
#'         SourceIpV4 = "string",
#'         SourceIpV6 = "string",
#'         SourcePort = 123,
#'         SourceDomain = "string",
#'         SourceMac = "string",
#'         DestinationIpV4 = "string",
#'         DestinationIpV6 = "string",
#'         DestinationPort = 123,
#'         DestinationDomain = "string"
#'       ),
#'       Process = list(
#'         Name = "string",
#'         Path = "string",
#'         Pid = 123,
#'         ParentPid = 123,
#'         LaunchedAt = "string",
#'         TerminatedAt = "string"
#'       ),
#'       ThreatIntelIndicators = list(
#'         list(
#'           Type = "DOMAIN"|"EMAIL_ADDRESS"|"HASH_MD5"|"HASH_SHA1"|"HASH_SHA256"|"HASH_SHA512"|"IPV4_ADDRESS"|"IPV6_ADDRESS"|"MUTEX"|"PROCESS"|"URL",
#'           Value = "string",
#'           Category = "BACKDOOR"|"CARD_STEALER"|"COMMAND_AND_CONTROL"|"DROP_SITE"|"EXPLOIT_SITE"|"KEYLOGGER",
#'           LastObservedAt = "string",
#'           Source = "string",
#'           SourceUrl = "string"
#'         )
#'       ),
#'       Resources = list(
#'         list(
#'           Type = "string",
#'           Id = "string",
#'           Partition = "aws"|"aws-cn"|"aws-us-gov",
#'           Region = "string",
#'           Tags = list(
#'             "string"
#'           ),
#'           Details = list(
#'             AwsEc2Instance = list(
#'               Type = "string",
#'               ImageId = "string",
#'               IpV4Addresses = list(
#'                 "string"
#'               ),
#'               IpV6Addresses = list(
#'                 "string"
#'               ),
#'               KeyName = "string",
#'               IamInstanceProfileArn = "string",
#'               VpcId = "string",
#'               SubnetId = "string",
#'               LaunchedAt = "string"
#'             ),
#'             AwsS3Bucket = list(
#'               OwnerId = "string",
#'               OwnerName = "string"
#'             ),
#'             AwsIamAccessKey = list(
#'               UserName = "string",
#'               Status = "Active"|"Inactive",
#'               CreatedAt = "string"
#'             ),
#'             Container = list(
#'               Name = "string",
#'               ImageId = "string",
#'               ImageName = "string",
#'               LaunchedAt = "string"
#'             ),
#'             Other = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       Compliance = list(
#'         Status = "PASSED"|"WARNING"|"FAILED"|"NOT_AVAILABLE"
#'       ),
#'       VerificationState = "UNKNOWN"|"TRUE_POSITIVE"|"FALSE_POSITIVE"|"BENIGN_POSITIVE",
#'       WorkflowState = "NEW"|"ASSIGNED"|"IN_PROGRESS"|"DEFERRED"|"RESOLVED",
#'       RecordState = "ACTIVE"|"ARCHIVED",
#'       RelatedFindings = list(
#'         list(
#'           ProductArn = "string",
#'           Id = "string"
#'         )
#'       ),
#'       Note = list(
#'         Text = "string",
#'         UpdatedBy = "string",
#'         UpdatedAt = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_import_findings
securityhub_batch_import_findings <- function(Findings) {
  op <- new_operation(
    name = "BatchImportFindings",
    http_method = "POST",
    http_path = "/findings/import",
    paginator = list()
  )
  input <- .securityhub$batch_import_findings_input(Findings = Findings)
  output <- .securityhub$batch_import_findings_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_import_findings <- securityhub_batch_import_findings

#' Creates a custom action target in Security Hub
#'
#' Creates a custom action target in Security Hub. You can use custom
#' actions on findings and insights in Security Hub to trigger target
#' actions in Amazon CloudWatch Events.
#'
#' @usage
#' securityhub_create_action_target(Name, Description, Id)
#'
#' @param Name &#91;required&#93; The name of the custom action target.
#' @param Description &#91;required&#93; The description for the custom action target.
#' @param Id &#91;required&#93; The ID for the custom action target.
#'
#' @section Request syntax:
#' ```
#' svc$create_action_target(
#'   Name = "string",
#'   Description = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_create_action_target
securityhub_create_action_target <- function(Name, Description, Id) {
  op <- new_operation(
    name = "CreateActionTarget",
    http_method = "POST",
    http_path = "/actionTargets",
    paginator = list()
  )
  input <- .securityhub$create_action_target_input(Name = Name, Description = Description, Id = Id)
  output <- .securityhub$create_action_target_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$create_action_target <- securityhub_create_action_target

#' Creates a custom insight in Security Hub
#'
#' Creates a custom insight in Security Hub. An insight is a consolidation
#' of findings that relate to a security issue that requires attention or
#' remediation. Use the `GroupByAttribute` to group the related findings in
#' the insight.
#'
#' @usage
#' securityhub_create_insight(Name, Filters, GroupByAttribute)
#'
#' @param Name &#91;required&#93; The name of the custom insight to create.
#' @param Filters &#91;required&#93; One or more attributes used to filter the findings included in the
#' insight. Only findings that match the criteria defined in the filters
#' are included in the insight.
#' @param GroupByAttribute &#91;required&#93; The attribute used as the aggregator to group related findings for the
#' insight.
#'
#' @section Request syntax:
#' ```
#' svc$create_insight(
#'   Name = "string",
#'   Filters = list(
#'     ProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     AwsAccountId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Id = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     GeneratorId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Type = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     FirstObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     LastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     CreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     UpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     SeverityProduct = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityNormalized = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityLabel = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Confidence = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Criticality = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Title = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Description = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RecommendationText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     SourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProductFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ProductName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     CompanyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     UserDefinedFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     MalwareName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwareType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwarePath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwareState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDirection = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkProtocol = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourceIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourcePort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkSourceDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceMac = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDestinationIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationPort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkDestinationDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessParentPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ProcessTerminatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorValue = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorCategory = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorLastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorSource = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorSourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourcePartition = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceRegion = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV4Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV6Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceKeyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIamInstanceProfileArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceVpcId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceSubnetId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyUserName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyCreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceContainerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceDetailsOther = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ComplianceStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     VerificationState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     WorkflowState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RecordState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NoteText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NoteUpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     NoteUpdatedBy = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Keyword = list(
#'       list(
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   GroupByAttribute = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_create_insight
securityhub_create_insight <- function(Name, Filters, GroupByAttribute) {
  op <- new_operation(
    name = "CreateInsight",
    http_method = "POST",
    http_path = "/insights",
    paginator = list()
  )
  input <- .securityhub$create_insight_input(Name = Name, Filters = Filters, GroupByAttribute = GroupByAttribute)
  output <- .securityhub$create_insight_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$create_insight <- securityhub_create_insight

#' Creates a member association in Security Hub between the specified
#' accounts and the account used to make the request, which is the master
#' account
#'
#' Creates a member association in Security Hub between the specified
#' accounts and the account used to make the request, which is the master
#' account. To successfully create a member, you must use this action from
#' an account that already has Security Hub enabled. You can use the
#' EnableSecurityHub to enable Security Hub.
#' 
#' After you use `CreateMembers` to create member account associations in
#' Security Hub, you need to use the InviteMembers action, which invites
#' the accounts to enable Security Hub and become member accounts in
#' Security Hub. If the invitation is accepted by the account owner, the
#' account becomes a member account in Security Hub, and a permission
#' policy is added that permits the master account to view the findings
#' generated in the member account. When Security Hub is enabled in the
#' invited account, findings start being sent to both the member and master
#' accounts.
#' 
#' You can remove the association between the master and member accounts by
#' using the DisassociateFromMasterAccount or DisassociateMembers
#' operation.
#'
#' @usage
#' securityhub_create_members(AccountDetails)
#'
#' @param AccountDetails A list of account ID and email address pairs of the accounts to
#' associate with the Security Hub master account.
#'
#' @section Request syntax:
#' ```
#' svc$create_members(
#'   AccountDetails = list(
#'     list(
#'       AccountId = "string",
#'       Email = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_create_members
securityhub_create_members <- function(AccountDetails = NULL) {
  op <- new_operation(
    name = "CreateMembers",
    http_method = "POST",
    http_path = "/members",
    paginator = list()
  )
  input <- .securityhub$create_members_input(AccountDetails = AccountDetails)
  output <- .securityhub$create_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$create_members <- securityhub_create_members

#' Declines invitations to become a member account
#'
#' Declines invitations to become a member account.
#'
#' @usage
#' securityhub_decline_invitations(AccountIds)
#'
#' @param AccountIds A list of account IDs that specify the accounts that invitations to
#' Security Hub are declined from.
#'
#' @section Request syntax:
#' ```
#' svc$decline_invitations(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_decline_invitations
securityhub_decline_invitations <- function(AccountIds = NULL) {
  op <- new_operation(
    name = "DeclineInvitations",
    http_method = "POST",
    http_path = "/invitations/decline",
    paginator = list()
  )
  input <- .securityhub$decline_invitations_input(AccountIds = AccountIds)
  output <- .securityhub$decline_invitations_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$decline_invitations <- securityhub_decline_invitations

#' Deletes a custom action target from Security Hub
#'
#' Deletes a custom action target from Security Hub. Deleting a custom
#' action target doesn\'t affect any findings or insights that were already
#' sent to Amazon CloudWatch Events using the custom action.
#'
#' @usage
#' securityhub_delete_action_target(ActionTargetArn)
#'
#' @param ActionTargetArn &#91;required&#93; The ARN of the custom action target to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_action_target(
#'   ActionTargetArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_action_target
securityhub_delete_action_target <- function(ActionTargetArn) {
  op <- new_operation(
    name = "DeleteActionTarget",
    http_method = "DELETE",
    http_path = "/actionTargets/{ActionTargetArn+}",
    paginator = list()
  )
  input <- .securityhub$delete_action_target_input(ActionTargetArn = ActionTargetArn)
  output <- .securityhub$delete_action_target_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_action_target <- securityhub_delete_action_target

#' Deletes the insight specified by the InsightArn
#'
#' Deletes the insight specified by the `InsightArn`.
#'
#' @usage
#' securityhub_delete_insight(InsightArn)
#'
#' @param InsightArn &#91;required&#93; The ARN of the insight to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_insight(
#'   InsightArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_insight
securityhub_delete_insight <- function(InsightArn) {
  op <- new_operation(
    name = "DeleteInsight",
    http_method = "DELETE",
    http_path = "/insights/{InsightArn+}",
    paginator = list()
  )
  input <- .securityhub$delete_insight_input(InsightArn = InsightArn)
  output <- .securityhub$delete_insight_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_insight <- securityhub_delete_insight

#' Deletes invitations received by the AWS account to become a member
#' account
#'
#' Deletes invitations received by the AWS account to become a member
#' account.
#'
#' @usage
#' securityhub_delete_invitations(AccountIds)
#'
#' @param AccountIds A list of the account IDs that sent the invitations to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_invitations(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_invitations
securityhub_delete_invitations <- function(AccountIds = NULL) {
  op <- new_operation(
    name = "DeleteInvitations",
    http_method = "POST",
    http_path = "/invitations/delete",
    paginator = list()
  )
  input <- .securityhub$delete_invitations_input(AccountIds = AccountIds)
  output <- .securityhub$delete_invitations_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_invitations <- securityhub_delete_invitations

#' Deletes the specified member accounts from Security Hub
#'
#' Deletes the specified member accounts from Security Hub.
#'
#' @usage
#' securityhub_delete_members(AccountIds)
#'
#' @param AccountIds A list of account IDs of the member accounts to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_members(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_members
securityhub_delete_members <- function(AccountIds = NULL) {
  op <- new_operation(
    name = "DeleteMembers",
    http_method = "POST",
    http_path = "/members/delete",
    paginator = list()
  )
  input <- .securityhub$delete_members_input(AccountIds = AccountIds)
  output <- .securityhub$delete_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_members <- securityhub_delete_members

#' Returns a list of the custom action targets in Security Hub in your
#' account
#'
#' Returns a list of the custom action targets in Security Hub in your
#' account.
#'
#' @usage
#' securityhub_describe_action_targets(ActionTargetArns, NextToken,
#'   MaxResults)
#'
#' @param ActionTargetArns A list of custom action target ARNs for the custom action targets to
#' retrieve.
#' @param NextToken The token that is required for pagination.
#' @param MaxResults The maximum number of results to return.
#'
#' @section Request syntax:
#' ```
#' svc$describe_action_targets(
#'   ActionTargetArns = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_describe_action_targets
securityhub_describe_action_targets <- function(ActionTargetArns = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeActionTargets",
    http_method = "POST",
    http_path = "/actionTargets/get",
    paginator = list()
  )
  input <- .securityhub$describe_action_targets_input(ActionTargetArns = ActionTargetArns, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$describe_action_targets_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$describe_action_targets <- securityhub_describe_action_targets

#' Returns details about the Hub resource in your account, including the
#' HubArn and the time when you enabled Security Hub
#'
#' Returns details about the Hub resource in your account, including the
#' `HubArn` and the time when you enabled Security Hub.
#'
#' @usage
#' securityhub_describe_hub(HubArn)
#'
#' @param HubArn The ARN of the Hub resource to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_hub(
#'   HubArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_describe_hub
securityhub_describe_hub <- function(HubArn = NULL) {
  op <- new_operation(
    name = "DescribeHub",
    http_method = "GET",
    http_path = "/accounts",
    paginator = list()
  )
  input <- .securityhub$describe_hub_input(HubArn = HubArn)
  output <- .securityhub$describe_hub_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$describe_hub <- securityhub_describe_hub

#' Returns information about the products available that you can subscribe
#' to and integrate with Security Hub to consolidate findings
#'
#' Returns information about the products available that you can subscribe
#' to and integrate with Security Hub to consolidate findings.
#'
#' @usage
#' securityhub_describe_products(NextToken, MaxResults)
#'
#' @param NextToken The token that is required for pagination.
#' @param MaxResults The maximum number of results to return.
#'
#' @section Request syntax:
#' ```
#' svc$describe_products(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_describe_products
securityhub_describe_products <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeProducts",
    http_method = "GET",
    http_path = "/products",
    paginator = list()
  )
  input <- .securityhub$describe_products_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$describe_products_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$describe_products <- securityhub_describe_products

#' Disables the integration of the specified product with Security Hub
#'
#' Disables the integration of the specified product with Security Hub.
#' Findings from that product are no longer sent to Security Hub after the
#' integration is disabled.
#'
#' @usage
#' securityhub_disable_import_findings_for_product(ProductSubscriptionArn)
#'
#' @param ProductSubscriptionArn &#91;required&#93; The ARN of the integrated product to disable the integration for.
#'
#' @section Request syntax:
#' ```
#' svc$disable_import_findings_for_product(
#'   ProductSubscriptionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_disable_import_findings_for_product
securityhub_disable_import_findings_for_product <- function(ProductSubscriptionArn) {
  op <- new_operation(
    name = "DisableImportFindingsForProduct",
    http_method = "DELETE",
    http_path = "/productSubscriptions/{ProductSubscriptionArn+}",
    paginator = list()
  )
  input <- .securityhub$disable_import_findings_for_product_input(ProductSubscriptionArn = ProductSubscriptionArn)
  output <- .securityhub$disable_import_findings_for_product_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disable_import_findings_for_product <- securityhub_disable_import_findings_for_product

#' Disables Security Hub in your account only in the current Region
#'
#' Disables Security Hub in your account only in the current Region. To
#' disable Security Hub in all Regions, you must submit one request per
#' Region where you have enabled Security Hub. When you disable Security
#' Hub for a master account, it doesn\'t disable Security Hub for any
#' associated member accounts.
#' 
#' When you disable Security Hub, your existing findings and insights and
#' any Security Hub configuration settings are deleted after 90 days and
#' can\'t be recovered. Any standards that were enabled are disabled, and
#' your master and member account associations are removed. If you want to
#' save your existing findings, you must export them before you disable
#' Security Hub.
#'
#' @usage
#' securityhub_disable_security_hub()
#'
#' @section Request syntax:
#' ```
#' svc$disable_security_hub()
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_disable_security_hub
securityhub_disable_security_hub <- function() {
  op <- new_operation(
    name = "DisableSecurityHub",
    http_method = "DELETE",
    http_path = "/accounts",
    paginator = list()
  )
  input <- .securityhub$disable_security_hub_input()
  output <- .securityhub$disable_security_hub_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disable_security_hub <- securityhub_disable_security_hub

#' Disassociates the current Security Hub member account from the
#' associated master account
#'
#' Disassociates the current Security Hub member account from the
#' associated master account.
#'
#' @usage
#' securityhub_disassociate_from_master_account()
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_from_master_account()
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_disassociate_from_master_account
securityhub_disassociate_from_master_account <- function() {
  op <- new_operation(
    name = "DisassociateFromMasterAccount",
    http_method = "POST",
    http_path = "/master/disassociate",
    paginator = list()
  )
  input <- .securityhub$disassociate_from_master_account_input()
  output <- .securityhub$disassociate_from_master_account_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disassociate_from_master_account <- securityhub_disassociate_from_master_account

#' Disassociates the specified member accounts from the associated master
#' account
#'
#' Disassociates the specified member accounts from the associated master
#' account.
#'
#' @usage
#' securityhub_disassociate_members(AccountIds)
#'
#' @param AccountIds The account IDs of the member accounts to disassociate from the master
#' account.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_members(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_disassociate_members
securityhub_disassociate_members <- function(AccountIds = NULL) {
  op <- new_operation(
    name = "DisassociateMembers",
    http_method = "POST",
    http_path = "/members/disassociate",
    paginator = list()
  )
  input <- .securityhub$disassociate_members_input(AccountIds = AccountIds)
  output <- .securityhub$disassociate_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disassociate_members <- securityhub_disassociate_members

#' Enables the integration of a partner product with Security Hub
#'
#' Enables the integration of a partner product with Security Hub.
#' Integrated products send findings to Security Hub. When you enable a
#' product integration, a permission policy that grants permission for the
#' product to send findings to Security Hub is applied.
#'
#' @usage
#' securityhub_enable_import_findings_for_product(ProductArn)
#'
#' @param ProductArn &#91;required&#93; The ARN of the product to enable the integration for.
#'
#' @section Request syntax:
#' ```
#' svc$enable_import_findings_for_product(
#'   ProductArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_enable_import_findings_for_product
securityhub_enable_import_findings_for_product <- function(ProductArn) {
  op <- new_operation(
    name = "EnableImportFindingsForProduct",
    http_method = "POST",
    http_path = "/productSubscriptions",
    paginator = list()
  )
  input <- .securityhub$enable_import_findings_for_product_input(ProductArn = ProductArn)
  output <- .securityhub$enable_import_findings_for_product_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$enable_import_findings_for_product <- securityhub_enable_import_findings_for_product

#' Enables Security Hub for your account in the current Region or the
#' Region you specify in the request
#'
#' Enables Security Hub for your account in the current Region or the
#' Region you specify in the request. When you enable Security Hub, you
#' grant to Security Hub the permissions necessary to gather findings from
#' AWS Config, Amazon GuardDuty, Amazon Inspector, and Amazon Macie. To
#' learn more, see [Setting Up AWS Security
#' Hub](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html).
#'
#' @usage
#' securityhub_enable_security_hub(Tags)
#'
#' @param Tags The tags to add to the Hub resource when you enable Security Hub.
#'
#' @section Request syntax:
#' ```
#' svc$enable_security_hub(
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_enable_security_hub
securityhub_enable_security_hub <- function(Tags = NULL) {
  op <- new_operation(
    name = "EnableSecurityHub",
    http_method = "POST",
    http_path = "/accounts",
    paginator = list()
  )
  input <- .securityhub$enable_security_hub_input(Tags = Tags)
  output <- .securityhub$enable_security_hub_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$enable_security_hub <- securityhub_enable_security_hub

#' Returns a list of the standards that are currently enabled
#'
#' Returns a list of the standards that are currently enabled.
#'
#' @usage
#' securityhub_get_enabled_standards(StandardsSubscriptionArns, NextToken,
#'   MaxResults)
#'
#' @param StandardsSubscriptionArns A list of the standards subscription ARNs for the standards to retrieve.
#' @param NextToken Paginates results. On your first call to the `GetEnabledStandards`
#' operation, set the value of this parameter to `NULL`. For subsequent
#' calls to the operation, fill `nextToken` in the request with the value
#' of `nextToken` from the previous response to continue listing data.
#' @param MaxResults The maximum number of results to return in the response.
#'
#' @section Request syntax:
#' ```
#' svc$get_enabled_standards(
#'   StandardsSubscriptionArns = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_enabled_standards
securityhub_get_enabled_standards <- function(StandardsSubscriptionArns = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetEnabledStandards",
    http_method = "POST",
    http_path = "/standards/get",
    paginator = list()
  )
  input <- .securityhub$get_enabled_standards_input(StandardsSubscriptionArns = StandardsSubscriptionArns, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$get_enabled_standards_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_enabled_standards <- securityhub_get_enabled_standards

#' Returns a list of findings that match the specified criteria
#'
#' Returns a list of findings that match the specified criteria.
#'
#' @usage
#' securityhub_get_findings(Filters, SortCriteria, NextToken, MaxResults)
#'
#' @param Filters The findings attributes used to define a condition to filter the
#' findings returned.
#' @param SortCriteria Findings attributes used to sort the list of findings returned.
#' @param NextToken Paginates results. On your first call to the `GetFindings` operation,
#' set the value of this parameter to `NULL`. For subsequent calls to the
#' operation, fill `nextToken` in the request with the value of `nextToken`
#' from the previous response to continue listing data.
#' @param MaxResults The maximum number of findings to return.
#'
#' @section Request syntax:
#' ```
#' svc$get_findings(
#'   Filters = list(
#'     ProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     AwsAccountId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Id = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     GeneratorId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Type = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     FirstObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     LastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     CreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     UpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     SeverityProduct = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityNormalized = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityLabel = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Confidence = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Criticality = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Title = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Description = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RecommendationText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     SourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProductFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ProductName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     CompanyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     UserDefinedFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     MalwareName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwareType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwarePath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwareState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDirection = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkProtocol = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourceIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourcePort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkSourceDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceMac = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDestinationIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationPort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkDestinationDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessParentPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ProcessTerminatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorValue = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorCategory = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorLastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorSource = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorSourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourcePartition = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceRegion = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV4Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV6Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceKeyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIamInstanceProfileArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceVpcId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceSubnetId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyUserName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyCreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceContainerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceDetailsOther = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ComplianceStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     VerificationState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     WorkflowState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RecordState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NoteText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NoteUpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     NoteUpdatedBy = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Keyword = list(
#'       list(
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   SortCriteria = list(
#'     list(
#'       Field = "string",
#'       SortOrder = "asc"|"desc"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_findings
securityhub_get_findings <- function(Filters = NULL, SortCriteria = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetFindings",
    http_method = "POST",
    http_path = "/findings",
    paginator = list()
  )
  input <- .securityhub$get_findings_input(Filters = Filters, SortCriteria = SortCriteria, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$get_findings_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_findings <- securityhub_get_findings

#' Lists the results of the Security Hub insight that the insight ARN
#' specifies
#'
#' Lists the results of the Security Hub insight that the insight ARN
#' specifies.
#'
#' @usage
#' securityhub_get_insight_results(InsightArn)
#'
#' @param InsightArn &#91;required&#93; The ARN of the insight whose results you want to see.
#'
#' @section Request syntax:
#' ```
#' svc$get_insight_results(
#'   InsightArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_insight_results
securityhub_get_insight_results <- function(InsightArn) {
  op <- new_operation(
    name = "GetInsightResults",
    http_method = "GET",
    http_path = "/insights/results/{InsightArn+}",
    paginator = list()
  )
  input <- .securityhub$get_insight_results_input(InsightArn = InsightArn)
  output <- .securityhub$get_insight_results_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_insight_results <- securityhub_get_insight_results

#' Lists and describes insights that insight ARNs specify
#'
#' Lists and describes insights that insight ARNs specify.
#'
#' @usage
#' securityhub_get_insights(InsightArns, NextToken, MaxResults)
#'
#' @param InsightArns The ARNs of the insights that you want to describe.
#' @param NextToken Paginates results. On your first call to the `GetInsights` operation,
#' set the value of this parameter to `NULL`. For subsequent calls to the
#' operation, fill `nextToken` in the request with the value of `nextToken`
#' from the previous response to continue listing data.
#' @param MaxResults The maximum number of items that you want in the response.
#'
#' @section Request syntax:
#' ```
#' svc$get_insights(
#'   InsightArns = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_insights
securityhub_get_insights <- function(InsightArns = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetInsights",
    http_method = "POST",
    http_path = "/insights/get",
    paginator = list()
  )
  input <- .securityhub$get_insights_input(InsightArns = InsightArns, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$get_insights_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_insights <- securityhub_get_insights

#' Returns the count of all Security Hub membership invitations that were
#' sent to the current member account, not including the currently accepted
#' invitation
#'
#' Returns the count of all Security Hub membership invitations that were
#' sent to the current member account, not including the currently accepted
#' invitation.
#'
#' @usage
#' securityhub_get_invitations_count()
#'
#' @section Request syntax:
#' ```
#' svc$get_invitations_count()
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_invitations_count
securityhub_get_invitations_count <- function() {
  op <- new_operation(
    name = "GetInvitationsCount",
    http_method = "GET",
    http_path = "/invitations/count",
    paginator = list()
  )
  input <- .securityhub$get_invitations_count_input()
  output <- .securityhub$get_invitations_count_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_invitations_count <- securityhub_get_invitations_count

#' Provides the details for the Security Hub master account to the current
#' member account
#'
#' Provides the details for the Security Hub master account to the current
#' member account.
#'
#' @usage
#' securityhub_get_master_account()
#'
#' @section Request syntax:
#' ```
#' svc$get_master_account()
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_master_account
securityhub_get_master_account <- function() {
  op <- new_operation(
    name = "GetMasterAccount",
    http_method = "GET",
    http_path = "/master",
    paginator = list()
  )
  input <- .securityhub$get_master_account_input()
  output <- .securityhub$get_master_account_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_master_account <- securityhub_get_master_account

#' Returns the details on the Security Hub member accounts that the account
#' IDs specify
#'
#' Returns the details on the Security Hub member accounts that the account
#' IDs specify.
#'
#' @usage
#' securityhub_get_members(AccountIds)
#'
#' @param AccountIds &#91;required&#93; A list of account IDs for the Security Hub member accounts that you want
#' to return the details for.
#'
#' @section Request syntax:
#' ```
#' svc$get_members(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_get_members
securityhub_get_members <- function(AccountIds) {
  op <- new_operation(
    name = "GetMembers",
    http_method = "POST",
    http_path = "/members/get",
    paginator = list()
  )
  input <- .securityhub$get_members_input(AccountIds = AccountIds)
  output <- .securityhub$get_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_members <- securityhub_get_members

#' Invites other AWS accounts to become member accounts for the Security
#' Hub master account that the invitation is sent from
#'
#' Invites other AWS accounts to become member accounts for the Security
#' Hub master account that the invitation is sent from. Before you can use
#' this action to invite a member, you must first create the member account
#' in Security Hub by using the CreateMembers action. When the account
#' owner accepts the invitation to become a member account and enables
#' Security Hub, the master account can view the findings generated from
#' member account.
#'
#' @usage
#' securityhub_invite_members(AccountIds)
#'
#' @param AccountIds A list of IDs of the AWS accounts that you want to invite to Security
#' Hub as members.
#'
#' @section Request syntax:
#' ```
#' svc$invite_members(
#'   AccountIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_invite_members
securityhub_invite_members <- function(AccountIds = NULL) {
  op <- new_operation(
    name = "InviteMembers",
    http_method = "POST",
    http_path = "/members/invite",
    paginator = list()
  )
  input <- .securityhub$invite_members_input(AccountIds = AccountIds)
  output <- .securityhub$invite_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$invite_members <- securityhub_invite_members

#' Lists all findings-generating solutions (products) whose findings you
#' have subscribed to receive in Security Hub
#'
#' Lists all findings-generating solutions (products) whose findings you
#' have subscribed to receive in Security Hub.
#'
#' @usage
#' securityhub_list_enabled_products_for_import(NextToken, MaxResults)
#'
#' @param NextToken Paginates results. On your first call to the
#' `ListEnabledProductsForImport` operation, set the value of this
#' parameter to `NULL`. For subsequent calls to the operation, fill
#' `nextToken` in the request with the value of `NextToken` from the
#' previous response to continue listing data.
#' @param MaxResults The maximum number of items that you want in the response.
#'
#' @section Request syntax:
#' ```
#' svc$list_enabled_products_for_import(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_list_enabled_products_for_import
securityhub_list_enabled_products_for_import <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEnabledProductsForImport",
    http_method = "GET",
    http_path = "/productSubscriptions",
    paginator = list()
  )
  input <- .securityhub$list_enabled_products_for_import_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$list_enabled_products_for_import_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_enabled_products_for_import <- securityhub_list_enabled_products_for_import

#' Lists all Security Hub membership invitations that were sent to the
#' current AWS account
#'
#' Lists all Security Hub membership invitations that were sent to the
#' current AWS account.
#'
#' @usage
#' securityhub_list_invitations(MaxResults, NextToken)
#'
#' @param MaxResults The maximum number of items that you want in the response.
#' @param NextToken Paginates results. On your first call to the `ListInvitations`
#' operation, set the value of this parameter to `NULL`. For subsequent
#' calls to the operation, fill `nextToken` in the request with the value
#' of `NextToken` from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_invitations(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_list_invitations
securityhub_list_invitations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInvitations",
    http_method = "GET",
    http_path = "/invitations",
    paginator = list()
  )
  input <- .securityhub$list_invitations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .securityhub$list_invitations_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_invitations <- securityhub_list_invitations

#' Lists details about all member accounts for the current Security Hub
#' master account
#'
#' Lists details about all member accounts for the current Security Hub
#' master account.
#'
#' @usage
#' securityhub_list_members(OnlyAssociated, MaxResults, NextToken)
#'
#' @param OnlyAssociated Specifies which member accounts the response includes based on their
#' relationship status with the master account. The default value is
#' `TRUE`. If `onlyAssociated` is set to `TRUE`, the response includes
#' member accounts whose relationship status with the master is set to
#' `ENABLED` or `DISABLED`. If `onlyAssociated` is set to `FALSE`, the
#' response includes all existing member accounts.
#' @param MaxResults The maximum number of items that you want in the response.
#' @param NextToken Paginates results. Set the value of this parameter to `NULL` on your
#' first call to the `ListMembers` operation. For subsequent calls to the
#' operation, fill `nextToken` in the request with the value of `nextToken`
#' from the previous response to continue listing data.
#'
#' @section Request syntax:
#' ```
#' svc$list_members(
#'   OnlyAssociated = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_list_members
securityhub_list_members <- function(OnlyAssociated = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListMembers",
    http_method = "GET",
    http_path = "/members",
    paginator = list()
  )
  input <- .securityhub$list_members_input(OnlyAssociated = OnlyAssociated, MaxResults = MaxResults, NextToken = NextToken)
  output <- .securityhub$list_members_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_members <- securityhub_list_members

#' Returns a list of tags associated with a resource
#'
#' Returns a list of tags associated with a resource.
#'
#' @usage
#' securityhub_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource to retrieve tags for.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_list_tags_for_resource
securityhub_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .securityhub$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .securityhub$list_tags_for_resource_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_tags_for_resource <- securityhub_list_tags_for_resource

#' Adds one or more tags to a resource
#'
#' Adds one or more tags to a resource.
#'
#' @usage
#' securityhub_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource to apply the tags to.
#' @param Tags &#91;required&#93; The tags to add to the resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_tag_resource
securityhub_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .securityhub$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .securityhub$tag_resource_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$tag_resource <- securityhub_tag_resource

#' Removes one or more tags from a resource
#'
#' Removes one or more tags from a resource.
#'
#' @usage
#' securityhub_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource to remove the tags from.
#' @param TagKeys &#91;required&#93; The tag keys associated with the tags to remove from the resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_untag_resource
securityhub_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .securityhub$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .securityhub$untag_resource_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$untag_resource <- securityhub_untag_resource

#' Updates the name and description of a custom action target in Security
#' Hub
#'
#' Updates the name and description of a custom action target in Security
#' Hub.
#'
#' @usage
#' securityhub_update_action_target(ActionTargetArn, Name, Description)
#'
#' @param ActionTargetArn &#91;required&#93; The ARN of the custom action target to update.
#' @param Name The updated name of the custom action target.
#' @param Description The updated description for the custom action target.
#'
#' @section Request syntax:
#' ```
#' svc$update_action_target(
#'   ActionTargetArn = "string",
#'   Name = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_update_action_target
securityhub_update_action_target <- function(ActionTargetArn, Name = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateActionTarget",
    http_method = "PATCH",
    http_path = "/actionTargets/{ActionTargetArn+}",
    paginator = list()
  )
  input <- .securityhub$update_action_target_input(ActionTargetArn = ActionTargetArn, Name = Name, Description = Description)
  output <- .securityhub$update_action_target_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_action_target <- securityhub_update_action_target

#' Updates the Note and RecordState of the Security Hub-aggregated findings
#' that the filter attributes specify
#'
#' Updates the `Note` and `RecordState` of the Security Hub-aggregated
#' findings that the filter attributes specify. Any member account that can
#' view the finding also sees the update to the finding.
#'
#' @usage
#' securityhub_update_findings(Filters, Note, RecordState)
#'
#' @param Filters &#91;required&#93; A collection of attributes that specify which findings you want to
#' update.
#' @param Note The updated note for the finding.
#' @param RecordState The updated record state for the finding.
#'
#' @section Request syntax:
#' ```
#' svc$update_findings(
#'   Filters = list(
#'     ProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     AwsAccountId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Id = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     GeneratorId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Type = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     FirstObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     LastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     CreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     UpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     SeverityProduct = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityNormalized = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityLabel = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Confidence = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Criticality = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Title = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Description = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RecommendationText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     SourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProductFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ProductName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     CompanyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     UserDefinedFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     MalwareName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwareType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwarePath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwareState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDirection = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkProtocol = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourceIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourcePort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkSourceDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceMac = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDestinationIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationPort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkDestinationDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessParentPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ProcessTerminatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorValue = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorCategory = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorLastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorSource = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorSourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourcePartition = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceRegion = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV4Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV6Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceKeyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIamInstanceProfileArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceVpcId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceSubnetId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyUserName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyCreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceContainerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceDetailsOther = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ComplianceStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     VerificationState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     WorkflowState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RecordState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NoteText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NoteUpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     NoteUpdatedBy = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Keyword = list(
#'       list(
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   Note = list(
#'     Text = "string",
#'     UpdatedBy = "string"
#'   ),
#'   RecordState = "ACTIVE"|"ARCHIVED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_update_findings
securityhub_update_findings <- function(Filters, Note = NULL, RecordState = NULL) {
  op <- new_operation(
    name = "UpdateFindings",
    http_method = "PATCH",
    http_path = "/findings",
    paginator = list()
  )
  input <- .securityhub$update_findings_input(Filters = Filters, Note = Note, RecordState = RecordState)
  output <- .securityhub$update_findings_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_findings <- securityhub_update_findings

#' Updates the Security Hub insight that the insight ARN specifies
#'
#' Updates the Security Hub insight that the insight ARN specifies.
#'
#' @usage
#' securityhub_update_insight(InsightArn, Name, Filters, GroupByAttribute)
#'
#' @param InsightArn &#91;required&#93; The ARN of the insight that you want to update.
#' @param Name The updated name for the insight.
#' @param Filters The updated filters that define this insight.
#' @param GroupByAttribute The updated `GroupBy` attribute that defines this insight.
#'
#' @section Request syntax:
#' ```
#' svc$update_insight(
#'   InsightArn = "string",
#'   Name = "string",
#'   Filters = list(
#'     ProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     AwsAccountId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Id = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     GeneratorId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Type = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     FirstObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     LastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     CreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     UpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     SeverityProduct = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityNormalized = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     SeverityLabel = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Confidence = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Criticality = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     Title = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Description = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RecommendationText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     SourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProductFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ProductName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     CompanyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     UserDefinedFields = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     MalwareName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwareType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwarePath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     MalwareState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDirection = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkProtocol = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourceIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkSourcePort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkSourceDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkSourceMac = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NetworkDestinationIpV4 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationIpV6 = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     NetworkDestinationPort = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     NetworkDestinationDomain = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPath = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ProcessPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessParentPid = list(
#'       list(
#'         Gte = 123.0,
#'         Lte = 123.0,
#'         Eq = 123.0
#'       )
#'     ),
#'     ProcessLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ProcessTerminatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorValue = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorCategory = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorLastObservedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ThreatIntelIndicatorSource = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ThreatIntelIndicatorSourceUrl = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourcePartition = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceRegion = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceType = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV4Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIpV6Addresses = list(
#'       list(
#'         Cidr = "string"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceKeyName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceIamInstanceProfileArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceVpcId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceSubnetId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsEc2InstanceLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsS3BucketOwnerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyUserName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceAwsIamAccessKeyCreatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceContainerName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerImageName = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     ResourceContainerLaunchedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     ResourceDetailsOther = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Comparison = "EQUALS"
#'       )
#'     ),
#'     ComplianceStatus = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     VerificationState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     WorkflowState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RecordState = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsProductArn = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     RelatedFindingsId = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NoteText = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     NoteUpdatedAt = list(
#'       list(
#'         Start = "string",
#'         End = "string",
#'         DateRange = list(
#'           Value = 123,
#'           Unit = "DAYS"
#'         )
#'       )
#'     ),
#'     NoteUpdatedBy = list(
#'       list(
#'         Value = "string",
#'         Comparison = "EQUALS"|"PREFIX"
#'       )
#'     ),
#'     Keyword = list(
#'       list(
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   GroupByAttribute = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname securityhub_update_insight
securityhub_update_insight <- function(InsightArn, Name = NULL, Filters = NULL, GroupByAttribute = NULL) {
  op <- new_operation(
    name = "UpdateInsight",
    http_method = "PATCH",
    http_path = "/insights/{InsightArn+}",
    paginator = list()
  )
  input <- .securityhub$update_insight_input(InsightArn = InsightArn, Name = Name, Filters = Filters, GroupByAttribute = GroupByAttribute)
  output <- .securityhub$update_insight_output()
  svc <- .securityhub$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_insight <- securityhub_update_insight
