% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_get_random_password}
\alias{secretsmanager_get_random_password}
\title{Generates a random password of the specified complexity}
\usage{
secretsmanager_get_random_password(PasswordLength, ExcludeCharacters,
  ExcludeNumbers, ExcludePunctuation, ExcludeUppercase, ExcludeLowercase,
  IncludeSpace, RequireEachIncludedType)
}
\arguments{
\item{PasswordLength}{The desired length of the generated password. The default value if you
do not include this parameter is 32 characters.}

\item{ExcludeCharacters}{A string that includes characters that should not be included in the
generated password. The default is that all characters from the included
sets can be used.}

\item{ExcludeNumbers}{Specifies that the generated password should not include digits. The
default if you do not include this switch parameter is that digits can
be included.}

\item{ExcludePunctuation}{Specifies that the generated password should not include punctuation
characters. The default if you do not include this switch parameter is
that punctuation characters can be included.

The following are the punctuation characters that \emph{can} be included in
the generated password if you don't explicitly exclude them with
\code{ExcludeCharacters} or \code{ExcludePunctuation}:

\code{! \" # $ \\\% &amp; \' ( ) * + , - . / : ; &lt; = &gt; ? @ \\[ \\ \\] ^ _ \` \{ | \} ~}}

\item{ExcludeUppercase}{Specifies that the generated password should not include uppercase
letters. The default if you do not include this switch parameter is that
uppercase letters can be included.}

\item{ExcludeLowercase}{Specifies that the generated password should not include lowercase
letters. The default if you do not include this switch parameter is that
lowercase letters can be included.}

\item{IncludeSpace}{Specifies that the generated password can include the space character.
The default if you do not include this switch parameter is that the
space character is not included.}

\item{RequireEachIncludedType}{A boolean value that specifies whether the generated password must
include at least one of every allowed character type. The default value
is \code{True} and the operation requires at least one of every character
type.}
}
\description{
Generates a random password of the specified complexity. This operation
is intended for use in the Lambda rotation function. Per best practice,
we recommend that you specify the maximum length and include every
character type that the system you are generating a password for can
support.
}
\details{
\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:GetRandomPassword
}
}
\section{Request syntax}{
\preformatted{svc$get_random_password(
  PasswordLength = 123,
  ExcludeCharacters = "string",
  ExcludeNumbers = TRUE|FALSE,
  ExcludePunctuation = TRUE|FALSE,
  ExcludeUppercase = TRUE|FALSE,
  ExcludeLowercase = TRUE|FALSE,
  IncludeSpace = TRUE|FALSE,
  RequireEachIncludedType = TRUE|FALSE
)
}
}

\examples{
# The following example shows how to request a randomly generated
# password. This example includes the optional flags to require spaces and
# at least one character of each included type. It specifies a length of
# 20 characters.
\donttest{svc$get_random_password(
  IncludeSpace = TRUE,
  PasswordLength = 20L,
  RequireEachIncludedType = TRUE
)}

}
\keyword{internal}
