% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_delete_custom_key_store}
\alias{kms_delete_custom_key_store}
\title{Deletes a custom key store}
\usage{
kms_delete_custom_key_store(CustomKeyStoreId)
}
\arguments{
\item{CustomKeyStoreId}{[required] Enter the ID of the custom key store you want to delete. To find the ID
of a custom key store, use the DescribeCustomKeyStores operation.}
}
\description{
Deletes a \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store}.
This operation does not delete the AWS CloudHSM cluster that is
associated with the custom key store, or affect any users or keys in the
cluster.
}
\details{
The custom key store that you delete cannot contain any AWS KMS
\href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys}{customer master keys (CMKs)}.
Before deleting the key store, verify that you will never need to use
any of the CMKs in the key store for any cryptographic operations. Then,
use ScheduleKeyDeletion to delete the AWS KMS customer master keys
(CMKs) from the key store. When the scheduled waiting period expires,
the \code{ScheduleKeyDeletion} operation deletes the CMKs. Then it makes a
best effort to delete the key material from the associated cluster.
However, you might need to manually \href{https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key}{delete the orphaned key material}
from the cluster and its backups.

After all CMKs are deleted from AWS KMS, use DisconnectCustomKeyStore to
disconnect the key store from AWS KMS. Then, you can delete the custom
key store.

Instead of deleting the custom key store, consider using
DisconnectCustomKeyStore to disconnect it from AWS KMS. While the key
store is disconnected, you cannot create or use the CMKs in the key
store. But, you do not need to delete CMKs and you can reconnect a
disconnected custom key store at any time.

If the operation succeeds, it returns a JSON object with no properties.

This operation is part of the \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{Custom Key Store feature}
feature in AWS KMS, which combines the convenience and extensive
integration of AWS KMS with the isolation and control of a single-tenant
key store.
}
\section{Request syntax}{
\preformatted{svc$delete_custom_key_store(
  CustomKeyStoreId = "string"
)
}
}

\keyword{internal}
