% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_update_custom_key_store}
\alias{kms_update_custom_key_store}
\title{Changes the properties of a custom key store}
\usage{
kms_update_custom_key_store(CustomKeyStoreId, NewCustomKeyStoreName,
  KeyStorePassword, CloudHsmClusterId)
}
\arguments{
\item{CustomKeyStoreId}{[required] Identifies the custom key store that you want to update. Enter the ID of
the custom key store. To find the ID of a custom key store, use the
DescribeCustomKeyStores operation.}

\item{NewCustomKeyStoreName}{Changes the friendly name of the custom key store to the value that you
specify. The custom key store name must be unique in the AWS account.}

\item{KeyStorePassword}{Enter the current password of the \code{kmsuser} crypto user (CU) in the AWS
CloudHSM cluster that is associated with the custom key store.

This parameter tells AWS KMS the current password of the \code{kmsuser}
crypto user (CU). It does not set or change the password of any users in
the AWS CloudHSM cluster.}

\item{CloudHsmClusterId}{Associates the custom key store with a related AWS CloudHSM cluster.

Enter the cluster ID of the cluster that you used to create the custom
key store or a cluster that shares a backup history and has the same
cluster certificate as the original cluster. You cannot use this
parameter to associate a custom key store with an unrelated cluster. In
addition, the replacement cluster must \href{https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore}{fulfill the requirements}
for a cluster associated with a custom key store. To view the cluster
certificate of a cluster, use the
\href{https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html}{DescribeClusters}
operation.}
}
\description{
Changes the properties of a custom key store. Use the \code{CustomKeyStoreId}
parameter to identify the custom key store you want to edit. Use the
remaining parameters to change the properties of the custom key store.
}
\details{
You can only update a custom key store that is disconnected. To
disconnect the custom key store, use DisconnectCustomKeyStore. To
reconnect the custom key store after the update completes, use
ConnectCustomKeyStore. To find the connection state of a custom key
store, use the DescribeCustomKeyStores operation.

Use the parameters of \code{UpdateCustomKeyStore} to edit your keystore
settings.
\itemize{
\item Use the \strong{NewCustomKeyStoreName} parameter to change the friendly
name of the custom key store to the value that you specify.
\item Use the \strong{KeyStorePassword} parameter tell AWS KMS the current
password of the \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser}{\code{kmsuser} crypto user (CU)}
in the associated AWS CloudHSM cluster. You can use this parameter
to \href{https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-password}{fix connection failures}
that occur when AWS KMS cannot log into the associated cluster
because the \code{kmsuser} password has changed. This value does not
change the password in the AWS CloudHSM cluster.
\item Use the \strong{CloudHsmClusterId} parameter to associate the custom key
store with a different, but related, AWS CloudHSM cluster. You can
use this parameter to repair a custom key store if its AWS CloudHSM
cluster becomes corrupted or is deleted, or when you need to create
or restore a cluster from a backup.
}

If the operation succeeds, it returns a JSON object with no properties.

This operation is part of the \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{Custom Key Store feature}
feature in AWS KMS, which combines the convenience and extensive
integration of AWS KMS with the isolation and control of a single-tenant
key store.
}
\section{Request syntax}{
\preformatted{svc$update_custom_key_store(
  CustomKeyStoreId = "string",
  NewCustomKeyStoreName = "string",
  KeyStorePassword = "string",
  CloudHsmClusterId = "string"
)
}
}

\keyword{internal}
