% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_revoke_certificate}
\alias{acmpca_revoke_certificate}
\title{Revokes a certificate that was issued inside ACM Private CA}
\usage{
acmpca_revoke_certificate(
  CertificateAuthorityArn,
  CertificateSerial,
  RevocationReason
)
}
\arguments{
\item{CertificateAuthorityArn}{[required] Amazon Resource Name (ARN) of the private CA that issued the certificate
to be revoked. This must be of the form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }}

\item{CertificateSerial}{[required] Serial number of the certificate to be revoked. This must be in
hexadecimal format. You can retrieve the serial number by calling
\code{\link[=acmpca_get_certificate]{get_certificate}} with the Amazon Resource
Name (ARN) of the certificate you want and the ARN of your private CA.
The \strong{GetCertificate} action retrieves the certificate in the PEM
format. You can use the following OpenSSL command to list the
certificate in text format and copy the hexadecimal serial number.

\verb{openssl x509 -in file_path -text -noout}

You can also copy the serial number from the console or use the
\href{https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html}{DescribeCertificate}
action in the \emph{Certificate Manager API Reference}.}

\item{RevocationReason}{[required] Specifies why you revoked the certificate.}
}
\description{
Revokes a certificate that was issued inside ACM Private CA. If you enable a certificate revocation list (CRL) when you create or update your private CA, information about the revoked certificates will be included in the CRL. ACM Private CA writes the CRL to an S3 bucket that you specify. A CRL is typically updated approximately 30 minutes after a certificate is revoked. If for any reason the CRL update fails, ACM Private CA attempts makes further attempts every 15 minutes. With Amazon CloudWatch, you can create alarms for the metrics \code{CRLGenerated} and \code{MisconfiguredCRLBucket}. For more information, see \href{https://docs.aws.amazon.com/privateca/latest/userguide/PcaCloudWatch.html}{Supported CloudWatch Metrics}.

See \url{https://paws-r.github.io/docs/acmpca/revoke_certificate.html} for full documentation.
}
\keyword{internal}
