% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_update_user_pool}
\alias{cognitoidentityprovider_update_user_pool}
\title{This action might generate an SMS text message}
\usage{
cognitoidentityprovider_update_user_pool(
  UserPoolId,
  Policies = NULL,
  DeletionProtection = NULL,
  LambdaConfig = NULL,
  AutoVerifiedAttributes = NULL,
  SmsVerificationMessage = NULL,
  EmailVerificationMessage = NULL,
  EmailVerificationSubject = NULL,
  VerificationMessageTemplate = NULL,
  SmsAuthenticationMessage = NULL,
  UserAttributeUpdateSettings = NULL,
  MfaConfiguration = NULL,
  DeviceConfiguration = NULL,
  EmailConfiguration = NULL,
  SmsConfiguration = NULL,
  UserPoolTags = NULL,
  AdminCreateUserConfig = NULL,
  UserPoolAddOns = NULL,
  AccountRecoverySetting = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool you want to update.}

\item{Policies}{A container with the policies you want to update in a user pool.}

\item{DeletionProtection}{When active, \code{DeletionProtection} prevents accidental deletion of your
user pool. Before you can delete a user pool that you have protected
against deletion, you must deactivate this feature.

When you try to delete a protected user pool in a
\code{\link[=cognitoidentityprovider_delete_user_pool]{delete_user_pool}} API
request, Amazon Cognito returns an \code{InvalidParameterException} error. To
delete a protected user pool, send a new
\code{\link[=cognitoidentityprovider_delete_user_pool]{delete_user_pool}} request
after you deactivate deletion protection in an
\code{\link[=cognitoidentityprovider_update_user_pool]{update_user_pool}} API
request.}

\item{LambdaConfig}{The Lambda configuration information from the request to update the user
pool.}

\item{AutoVerifiedAttributes}{The attributes that are automatically verified when Amazon Cognito
requests to update user pools.}

\item{SmsVerificationMessage}{This parameter is no longer used. See
\href{https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html}{VerificationMessageTemplateType}.}

\item{EmailVerificationMessage}{This parameter is no longer used. See
\href{https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html}{VerificationMessageTemplateType}.}

\item{EmailVerificationSubject}{This parameter is no longer used. See
\href{https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html}{VerificationMessageTemplateType}.}

\item{VerificationMessageTemplate}{The template for verification messages.}

\item{SmsAuthenticationMessage}{The contents of the SMS authentication message.}

\item{UserAttributeUpdateSettings}{The settings for updates to user attributes. These settings include the
property \code{AttributesRequireVerificationBeforeUpdate}, a user-pool
setting that tells Amazon Cognito how to handle changes to the value of
your users' email address and phone number attributes. For more
information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates}{Verifying updates to email addresses and phone numbers}.}

\item{MfaConfiguration}{Possible values include:
\itemize{
\item \code{OFF} - MFA tokens aren't required and can't be specified during
user registration.
\item \code{ON} - MFA tokens are required for all user registrations. You can
only specify ON when you're initially creating a user pool. You can
use the
\code{\link[=cognitoidentityprovider_set_user_pool_mfa_config]{set_user_pool_mfa_config}}
API operation to turn MFA "ON" for existing user pools.
\item \code{OPTIONAL} - Users have the option when registering to create an MFA
token.
}}

\item{DeviceConfiguration}{The device-remembering configuration for a user pool. A null value
indicates that you have deactivated device remembering in your user
pool.

When you provide a value for any \code{DeviceConfiguration} field, you
activate the Amazon Cognito device-remembering feature.}

\item{EmailConfiguration}{The email configuration of your user pool. The email configuration type
sets your preferred sending method, Amazon Web Services Region, and
sender for email invitation and verification messages from your user
pool.}

\item{SmsConfiguration}{The SMS configuration with the settings that your Amazon Cognito user
pool must use to send an SMS message from your Amazon Web Services
account through Amazon Simple Notification Service. To send SMS messages
with Amazon SNS in the Amazon Web Services Region that you want, the
Amazon Cognito user pool uses an Identity and Access Management (IAM)
role in your Amazon Web Services account.}

\item{UserPoolTags}{The tag keys and values to assign to the user pool. A tag is a label
that you can use to categorize and manage user pools in different ways,
such as by purpose, owner, environment, or other criteria.}

\item{AdminCreateUserConfig}{The configuration for
\code{\link[=cognitoidentityprovider_admin_create_user]{admin_create_user}}
requests.}

\item{UserPoolAddOns}{User pool add-ons. Contains settings for activation of advanced security
features. To log user security information but take no action, set to
\code{AUDIT}. To configure automatic security responses to risky traffic to
your user pool, set to \code{ENFORCED}.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html}{Adding advanced security to a user pool}.}

\item{AccountRecoverySetting}{The available verified method a user can use to recover their password
when they call
\code{\link[=cognitoidentityprovider_forgot_password]{forgot_password}}. You can
use this setting to define a preferred method when a user has more than
one method available. With this setting, SMS doesn't qualify for a valid
password recovery mechanism if the user also has SMS multi-factor
authentication (MFA) activated. In the absence of this setting, Amazon
Cognito uses the legacy behavior to determine the recovery method where
SMS is preferred through email.}
}
\description{
This action might generate an SMS text message. Starting June 1, 2021, US telecom carriers require you to register an origination phone number before you can send SMS messages to US phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Amazon Cognito uses the registered number automatically. Otherwise, Amazon Cognito users who must receive SMS messages might not be able to sign up, activate their accounts, or sign in.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_user_pool/} for full documentation.
}
\keyword{internal}
