% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_create_alias}
\alias{kms_create_alias}
\title{Creates a friendly name for a KMS key}
\usage{
kms_create_alias(AliasName, TargetKeyId)
}
\arguments{
\item{AliasName}{[required] Specifies the alias name. This value must begin with \verb{alias/} followed
by a name, such as \code{alias/ExampleAlias}.

Do not include confidential or sensitive information in this field. This
field may be displayed in plaintext in CloudTrail logs and other output.

The \code{AliasName} value must be string of 1-256 characters. It can contain
only alphanumeric characters, forward slashes (/), underscores (_), and
dashes (-). The alias name cannot begin with \verb{alias/aws/}. The
\verb{alias/aws/} prefix is reserved for \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk}{Amazon Web Services managed keys}.}

\item{TargetKeyId}{[required] Associates the alias with the specified \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk}{customer managed key}.
The KMS key must be in the same Amazon Web Services Region.

A valid key ID is required. If you supply a null or empty string value,
this operation returns an error.

For help finding the key ID and ARN, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn}{Finding the Key ID and ARN}
in the \emph{Key Management Service Developer Guide} .

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}
}
\description{
Creates a friendly name for a KMS key.

See \url{https://www.paws-r-sdk.com/docs/kms_create_alias/} for full documentation.
}
\keyword{internal}
