% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_get_vault_lock}
\alias{glacier_get_vault_lock}
\title{This operation retrieves the following attributes from the lock-policy
subresource set on the specified vault: - The vault lock policy set on
the vault}
\usage{
glacier_get_vault_lock(accountId, vaultName)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
\'\code{-}\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
ID associated with the credentials used to sign the request. If you use
an account ID, do not include any hyphens (\'-\') in the ID.}

\item{vaultName}{[required] The name of the vault.}
}
\description{
This operation retrieves the following attributes from the \code{lock-policy}
subresource set on the specified vault:
}
\details{
\itemize{
\item The vault lock policy set on the vault.
\item The state of the vault lock, which is either \code{InProgess} or
\code{Locked}.
\item When the lock ID expires. The lock ID is used to complete the vault
locking process.
\item When the vault lock was initiated and put into the \code{InProgress}
state.
}

A vault lock is put into the \code{InProgress} state by calling
InitiateVaultLock. A vault lock is put into the \code{Locked} state by
calling CompleteVaultLock. You can abort the vault locking process by
calling AbortVaultLock. For more information about the vault locking
process, \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html}{Amazon Glacier Vault Lock}.

If there is no vault lock policy set on the vault, the operation returns
a \verb{404 Not found} error. For more information about vault lock policies,
\href{https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html}{Amazon Glacier Access Control with Vault Lock Policies}.
}
\section{Request syntax}{
\preformatted{svc$get_vault_lock(
  accountId = "string",
  vaultName = "string"
)
}
}

\examples{
# The example retrieves the attributes from the lock-policy subresource
# set on the vault named examplevault.
\dontrun{svc$get_vault_lock(
  accountId = "-",
  vaultName = "examplevault"
)}

}
\keyword{internal}
