% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_create_file_system_from_backup}
\alias{fsx_create_file_system_from_backup}
\title{Creates a new Amazon FSx file system from an existing Amazon FSx backup}
\usage{
fsx_create_file_system_from_backup(BackupId, ClientRequestToken,
  SubnetIds, SecurityGroupIds, Tags, WindowsConfiguration,
  LustreConfiguration, StorageType)
}
\arguments{
\item{BackupId}{[required]}

\item{ClientRequestToken}{A string of up to 64 ASCII characters that Amazon FSx uses to ensure
idempotent creation. This string is automatically filled on your behalf
when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.}

\item{SubnetIds}{[required] Specifies the IDs of the subnets that the file system will be accessible
from. For Windows \code{MULTI_AZ_1} file system deployment types, provide
exactly two subnet IDs, one for the preferred file server and one for
the standby file server. You specify one of these subnets as the
preferred subnet using the \verb{WindowsConfiguration &gt; PreferredSubnetID}
property.

For Windows \code{SINGLE_AZ_1} and \code{SINGLE_AZ_2} deployment types and Lustre
file systems, provide exactly one subnet ID. The file server is launched
in that subnet\'s Availability Zone.}

\item{SecurityGroupIds}{A list of IDs for the security groups that apply to the specified
network interfaces created for file system access. These security groups
apply to all network interfaces. This value isn\'t returned in later
DescribeFileSystem requests.}

\item{Tags}{The tags to be applied to the file system at file system creation. The
key value of the \code{Name} tag appears in the console as the file system
name.}

\item{WindowsConfiguration}{The configuration for this Microsoft Windows file system.}

\item{LustreConfiguration}{}

\item{StorageType}{Sets the storage type for the Windows file system you\'re creating from
a backup. Valid values are \code{SSD} and \code{HDD}.
\itemize{
\item Set to \code{SSD} to use solid state drive storage. Supported on all
Windows deployment types.
\item Set to \code{HDD} to use hard disk drive storage. Supported on
\code{SINGLE_AZ_2} and \code{MULTI_AZ_1} Windows file system deployment types.
}

Default value is \code{SSD}.

HDD and SSD storage types have different minimum storage capacity
requirements. A restored file system\'s storage capacity is tied to the
file system that was backed up. You can create a file system that uses
HDD storage from a backup of a file system that used SSD storage only if
the original SSD file system had a storage capacity of at least 2000
GiB.}
}
\description{
Creates a new Amazon FSx file system from an existing Amazon FSx backup.
}
\details{
If a file system with the specified client request token exists and the
parameters match, this operation returns the description of the file
system. If a client request token specified by the file system exists
and the parameters don\'t match, this call returns
\code{IncompatibleParameterError}. If a file system with the specified client
request token doesn\'t exist, this operation does the following:
\itemize{
\item Creates a new Amazon FSx file system from backup with an assigned
ID, and an initial lifecycle state of \code{CREATING}.
\item Returns the description of the file system.
}

Parameters like Active Directory, default share name, automatic backup,
and backup settings default to the parameters of the file system that
was backed up, unless overridden. You can explicitly supply other
settings.

By using the idempotent operation, you can retry a
\code{CreateFileSystemFromBackup} call without the risk of creating an extra
file system. This approach can be useful when an initial call fails in a
way that makes it unclear whether a file system was created. Examples
are if a transport level timeout occurred, or your connection was reset.
If you use the same client request token and the initial call created a
file system, the client receives success as long as the parameters are
the same.

The \code{CreateFileSystemFromBackup} call returns while the file system\'s
lifecycle state is still \code{CREATING}. You can check the file-system
creation status by calling the DescribeFileSystems operation, which
returns the file system state along with other information.
}
\section{Request syntax}{
\preformatted{svc$create_file_system_from_backup(
  BackupId = "string",
  ClientRequestToken = "string",
  SubnetIds = list(
    "string"
  ),
  SecurityGroupIds = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  WindowsConfiguration = list(
    ActiveDirectoryId = "string",
    SelfManagedActiveDirectoryConfiguration = list(
      DomainName = "string",
      OrganizationalUnitDistinguishedName = "string",
      FileSystemAdministratorsGroup = "string",
      UserName = "string",
      Password = "string",
      DnsIps = list(
        "string"
      )
    ),
    DeploymentType = "MULTI_AZ_1"|"SINGLE_AZ_1"|"SINGLE_AZ_2",
    PreferredSubnetId = "string",
    ThroughputCapacity = 123,
    WeeklyMaintenanceStartTime = "string",
    DailyAutomaticBackupStartTime = "string",
    AutomaticBackupRetentionDays = 123,
    CopyTagsToBackups = TRUE|FALSE
  ),
  LustreConfiguration = list(
    WeeklyMaintenanceStartTime = "string",
    ImportPath = "string",
    ExportPath = "string",
    ImportedFileChunkSize = 123,
    DeploymentType = "SCRATCH_1"|"SCRATCH_2"|"PERSISTENT_1",
    PerUnitStorageThroughput = 123,
    DailyAutomaticBackupStartTime = "string",
    AutomaticBackupRetentionDays = 123,
    CopyTagsToBackups = TRUE|FALSE
  ),
  StorageType = "SSD"|"HDD"
)
}
}

\examples{
\dontrun{
# This operation creates a new file system from backup.
svc$create_file_system_from_backup(
  BackupId = "backup-03e3c82e0183b7b6b",
  ClientRequestToken = "f4c94ed7-238d-4c46-93db-48cd62ec33b7",
  SecurityGroupIds = list(
    "sg-edcd9784"
  ),
  SubnetIds = list(
    "subnet-1234abcd"
  ),
  Tags = list(
    list(
      Key = "Name",
      Value = "MyFileSystem"
    )
  ),
  WindowsConfiguration = list(
    ThroughputCapacity = 8L
  )
)
}

}
\keyword{internal}
