% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_request_payment}
\alias{s3_put_bucket_request_payment}
\title{Sets the request payment configuration for a bucket}
\usage{
s3_put_bucket_request_payment(Bucket, ContentMD5,
  RequestPaymentConfiguration)
}
\arguments{
\item{Bucket}{[required] The bucket name.}

\item{ContentMD5}{\\>The base64-encoded 128-bit MD5 digest of the data. You must use this
header as a message integrity check to verify that the request body was
not corrupted in transit. For more information, see \href{http://www.ietf.org/rfc/rfc1864.txt}{RFC 1864}.}

\item{RequestPaymentConfiguration}{[required] Container for Payer.}
}
\description{
Sets the request payment configuration for a bucket. By default, the
bucket owner pays for downloads from the bucket. This configuration
parameter enables the bucket owner (only) to specify that the person
requesting the download will be charged for the download. For more
information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html}{Requester Pays Buckets}.
}
\details{
The following operations are related to \code{PutBucketRequestPayment}:
\itemize{
\item CreateBucket
\item GetBucketRequestPayment
}
}
\section{Request syntax}{
\preformatted{svc$put_bucket_request_payment(
  Bucket = "string",
  ContentMD5 = "string",
  RequestPaymentConfiguration = list(
    Payer = "Requester"|"BucketOwner"
  )
)
}
}

\examples{
\dontrun{
# The following example sets request payment configuration on a bucket so
# that person requesting the download is charged.
svc$put_bucket_request_payment(
  Bucket = "examplebucket",
  RequestPaymentConfiguration = list(
    Payer = "Requester"
  )
)
}

}
\keyword{internal}
