% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omics_operations.R
\name{omics_start_run}
\alias{omics_start_run}
\title{Starts a workflow run}
\usage{
omics_start_run(
  workflowId = NULL,
  workflowType = NULL,
  runId = NULL,
  roleArn,
  name = NULL,
  runGroupId = NULL,
  priority = NULL,
  parameters = NULL,
  storageCapacity = NULL,
  outputUri = NULL,
  logLevel = NULL,
  tags = NULL,
  requestId,
  retentionMode = NULL
)
}
\arguments{
\item{workflowId}{The run's workflow ID.}

\item{workflowType}{The run's workflow type.}

\item{runId}{The ID of a run to duplicate.}

\item{roleArn}{[required] A service role for the run.}

\item{name}{A name for the run.}

\item{runGroupId}{The run's group ID.}

\item{priority}{A priority for the run.}

\item{parameters}{Parameters for the run.}

\item{storageCapacity}{A storage capacity for the run in gigabytes.}

\item{outputUri}{An output URI for the run.}

\item{logLevel}{A log level for the run.}

\item{tags}{Tags for the run.}

\item{requestId}{[required] To ensure that requests don't run multiple times, specify a unique ID
for each request.}

\item{retentionMode}{The retention mode for the run.}
}
\description{
Starts a workflow run. To duplicate a run, specify the run's ID and a role ARN. The remaining parameters are copied from the previous run.

See \url{https://www.paws-r-sdk.com/docs/omics_start_run/} for full documentation.
}
\keyword{internal}
