% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{forecastservice}
\alias{forecastservice}
\title{Amazon Forecast Service}
\usage{
forecastservice(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Provides APIs for creating and managing Amazon Forecast resources.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- forecastservice(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.machine.learning:forecastservice_create_auto_predictor]{create_auto_predictor} \tab Creates an Amazon Forecast predictor\cr
\link[paws.machine.learning:forecastservice_create_dataset]{create_dataset} \tab Creates an Amazon Forecast dataset\cr
\link[paws.machine.learning:forecastservice_create_dataset_group]{create_dataset_group} \tab Creates a dataset group, which holds a collection of related datasets\cr
\link[paws.machine.learning:forecastservice_create_dataset_import_job]{create_dataset_import_job} \tab Imports your training data to an Amazon Forecast dataset\cr
\link[paws.machine.learning:forecastservice_create_explainability]{create_explainability} \tab Explainability is only available for Forecasts and Predictors generated from an AutoPredictor (CreateAutoPredictor)\cr
\link[paws.machine.learning:forecastservice_create_explainability_export]{create_explainability_export} \tab Exports an Explainability resource created by the CreateExplainability operation\cr
\link[paws.machine.learning:forecastservice_create_forecast]{create_forecast} \tab Creates a forecast for each item in the TARGET_TIME_SERIES dataset that was used to train the predictor\cr
\link[paws.machine.learning:forecastservice_create_forecast_export_job]{create_forecast_export_job} \tab Exports a forecast created by the CreateForecast operation to your Amazon Simple Storage Service (Amazon S3) bucket\cr
\link[paws.machine.learning:forecastservice_create_monitor]{create_monitor} \tab Creates a predictor monitor resource for an existing auto predictor\cr
\link[paws.machine.learning:forecastservice_create_predictor]{create_predictor} \tab This operation creates a legacy predictor that does not include all the predictor functionalities provided by Amazon Forecast\cr
\link[paws.machine.learning:forecastservice_create_predictor_backtest_export_job]{create_predictor_backtest_export_job} \tab Exports backtest forecasts and accuracy metrics generated by the CreateAutoPredictor or CreatePredictor operations\cr
\link[paws.machine.learning:forecastservice_delete_dataset]{delete_dataset} \tab Deletes an Amazon Forecast dataset that was created using the CreateDataset operation\cr
\link[paws.machine.learning:forecastservice_delete_dataset_group]{delete_dataset_group} \tab Deletes a dataset group created using the CreateDatasetGroup operation\cr
\link[paws.machine.learning:forecastservice_delete_dataset_import_job]{delete_dataset_import_job} \tab Deletes a dataset import job created using the CreateDatasetImportJob operation\cr
\link[paws.machine.learning:forecastservice_delete_explainability]{delete_explainability} \tab Deletes an Explainability resource\cr
\link[paws.machine.learning:forecastservice_delete_explainability_export]{delete_explainability_export} \tab Deletes an Explainability export\cr
\link[paws.machine.learning:forecastservice_delete_forecast]{delete_forecast} \tab Deletes a forecast created using the CreateForecast operation\cr
\link[paws.machine.learning:forecastservice_delete_forecast_export_job]{delete_forecast_export_job} \tab Deletes a forecast export job created using the CreateForecastExportJob operation\cr
\link[paws.machine.learning:forecastservice_delete_monitor]{delete_monitor} \tab Deletes a monitor resource\cr
\link[paws.machine.learning:forecastservice_delete_predictor]{delete_predictor} \tab Deletes a predictor created using the DescribePredictor or CreatePredictor operations\cr
\link[paws.machine.learning:forecastservice_delete_predictor_backtest_export_job]{delete_predictor_backtest_export_job} \tab Deletes a predictor backtest export job\cr
\link[paws.machine.learning:forecastservice_delete_resource_tree]{delete_resource_tree} \tab Deletes an entire resource tree\cr
\link[paws.machine.learning:forecastservice_describe_auto_predictor]{describe_auto_predictor} \tab Describes a predictor created using the CreateAutoPredictor operation\cr
\link[paws.machine.learning:forecastservice_describe_dataset]{describe_dataset} \tab Describes an Amazon Forecast dataset created using the CreateDataset operation\cr
\link[paws.machine.learning:forecastservice_describe_dataset_group]{describe_dataset_group} \tab Describes a dataset group created using the CreateDatasetGroup operation\cr
\link[paws.machine.learning:forecastservice_describe_dataset_import_job]{describe_dataset_import_job} \tab Describes a dataset import job created using the CreateDatasetImportJob operation\cr
\link[paws.machine.learning:forecastservice_describe_explainability]{describe_explainability} \tab Describes an Explainability resource created using the CreateExplainability operation\cr
\link[paws.machine.learning:forecastservice_describe_explainability_export]{describe_explainability_export} \tab Describes an Explainability export created using the CreateExplainabilityExport operation\cr
\link[paws.machine.learning:forecastservice_describe_forecast]{describe_forecast} \tab Describes a forecast created using the CreateForecast operation\cr
\link[paws.machine.learning:forecastservice_describe_forecast_export_job]{describe_forecast_export_job} \tab Describes a forecast export job created using the CreateForecastExportJob operation\cr
\link[paws.machine.learning:forecastservice_describe_monitor]{describe_monitor} \tab Describes a monitor resource\cr
\link[paws.machine.learning:forecastservice_describe_predictor]{describe_predictor} \tab This operation is only valid for legacy predictors created with CreatePredictor\cr
\link[paws.machine.learning:forecastservice_describe_predictor_backtest_export_job]{describe_predictor_backtest_export_job} \tab Describes a predictor backtest export job created using the CreatePredictorBacktestExportJob operation\cr
\link[paws.machine.learning:forecastservice_get_accuracy_metrics]{get_accuracy_metrics} \tab Provides metrics on the accuracy of the models that were trained by the CreatePredictor operation\cr
\link[paws.machine.learning:forecastservice_list_dataset_groups]{list_dataset_groups} \tab Returns a list of dataset groups created using the CreateDatasetGroup operation\cr
\link[paws.machine.learning:forecastservice_list_dataset_import_jobs]{list_dataset_import_jobs} \tab Returns a list of dataset import jobs created using the CreateDatasetImportJob operation\cr
\link[paws.machine.learning:forecastservice_list_datasets]{list_datasets} \tab Returns a list of datasets created using the CreateDataset operation\cr
\link[paws.machine.learning:forecastservice_list_explainabilities]{list_explainabilities} \tab Returns a list of Explainability resources created using the CreateExplainability operation\cr
\link[paws.machine.learning:forecastservice_list_explainability_exports]{list_explainability_exports} \tab Returns a list of Explainability exports created using the CreateExplainabilityExport operation\cr
\link[paws.machine.learning:forecastservice_list_forecast_export_jobs]{list_forecast_export_jobs} \tab Returns a list of forecast export jobs created using the CreateForecastExportJob operation\cr
\link[paws.machine.learning:forecastservice_list_forecasts]{list_forecasts} \tab Returns a list of forecasts created using the CreateForecast operation\cr
\link[paws.machine.learning:forecastservice_list_monitor_evaluations]{list_monitor_evaluations} \tab Returns a list of the monitoring evaluation results and predictor events collected by the monitor resource during different windows of time\cr
\link[paws.machine.learning:forecastservice_list_monitors]{list_monitors} \tab Returns a list of monitors created with the CreateMonitor operation and CreateAutoPredictor operation\cr
\link[paws.machine.learning:forecastservice_list_predictor_backtest_export_jobs]{list_predictor_backtest_export_jobs} \tab Returns a list of predictor backtest export jobs created using the CreatePredictorBacktestExportJob operation\cr
\link[paws.machine.learning:forecastservice_list_predictors]{list_predictors} \tab Returns a list of predictors created using the CreateAutoPredictor or CreatePredictor operations\cr
\link[paws.machine.learning:forecastservice_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for an Amazon Forecast resource\cr
\link[paws.machine.learning:forecastservice_resume_resource]{resume_resource} \tab Resumes a stopped monitor resource\cr
\link[paws.machine.learning:forecastservice_stop_resource]{stop_resource} \tab Stops a resource\cr
\link[paws.machine.learning:forecastservice_tag_resource]{tag_resource} \tab Associates the specified tags to a resource with the specified resourceArn\cr
\link[paws.machine.learning:forecastservice_untag_resource]{untag_resource} \tab Deletes the specified tags from a resource\cr
\link[paws.machine.learning:forecastservice_update_dataset_group]{update_dataset_group} \tab Replaces the datasets in a dataset group with the specified datasets
}
}

\examples{
\dontrun{
svc <- forecastservice()
svc$create_auto_predictor(
  Foo = 123
)
}

}
