% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{wellarchitected}
\alias{wellarchitected}
\title{AWS Well-Architected Tool}
\usage{
wellarchitected(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Well-Architected Tool

This is the \emph{Well-Architected Tool API Reference}. The WA Tool API
provides programmatic access to the \href{https://aws.amazon.com/well-architected-tool/}{Well-Architected Tool} in the Amazon Web
Services Management Console. For information about the Well-Architected
Tool, see the \href{https://docs.aws.amazon.com/wellarchitected/latest/userguide/intro.html}{Well-Architected Tool User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- wellarchitected(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.developer.tools:wellarchitected_associate_lenses]{associate_lenses} \tab Associate a lens to a workload\cr
\link[paws.developer.tools:wellarchitected_create_lens_share]{create_lens_share} \tab Create a lens share\cr
\link[paws.developer.tools:wellarchitected_create_lens_version]{create_lens_version} \tab Create a new lens version\cr
\link[paws.developer.tools:wellarchitected_create_milestone]{create_milestone} \tab Create a milestone for an existing workload\cr
\link[paws.developer.tools:wellarchitected_create_workload]{create_workload} \tab Create a new workload\cr
\link[paws.developer.tools:wellarchitected_create_workload_share]{create_workload_share} \tab Create a workload share\cr
\link[paws.developer.tools:wellarchitected_delete_lens]{delete_lens} \tab Delete an existing lens\cr
\link[paws.developer.tools:wellarchitected_delete_lens_share]{delete_lens_share} \tab Delete a lens share\cr
\link[paws.developer.tools:wellarchitected_delete_workload]{delete_workload} \tab Delete an existing workload\cr
\link[paws.developer.tools:wellarchitected_delete_workload_share]{delete_workload_share} \tab Delete a workload share\cr
\link[paws.developer.tools:wellarchitected_disassociate_lenses]{disassociate_lenses} \tab Disassociate a lens from a workload\cr
\link[paws.developer.tools:wellarchitected_export_lens]{export_lens} \tab Export an existing lens\cr
\link[paws.developer.tools:wellarchitected_get_answer]{get_answer} \tab Get the answer to a specific question in a workload review\cr
\link[paws.developer.tools:wellarchitected_get_lens]{get_lens} \tab Get an existing lens\cr
\link[paws.developer.tools:wellarchitected_get_lens_review]{get_lens_review} \tab Get lens review\cr
\link[paws.developer.tools:wellarchitected_get_lens_review_report]{get_lens_review_report} \tab Get lens review report\cr
\link[paws.developer.tools:wellarchitected_get_lens_version_difference]{get_lens_version_difference} \tab Get lens version differences\cr
\link[paws.developer.tools:wellarchitected_get_milestone]{get_milestone} \tab Get a milestone for an existing workload\cr
\link[paws.developer.tools:wellarchitected_get_workload]{get_workload} \tab Get an existing workload\cr
\link[paws.developer.tools:wellarchitected_import_lens]{import_lens} \tab Import a new lens\cr
\link[paws.developer.tools:wellarchitected_list_answers]{list_answers} \tab List of answers\cr
\link[paws.developer.tools:wellarchitected_list_lenses]{list_lenses} \tab List the available lenses\cr
\link[paws.developer.tools:wellarchitected_list_lens_review_improvements]{list_lens_review_improvements} \tab List lens review improvements\cr
\link[paws.developer.tools:wellarchitected_list_lens_reviews]{list_lens_reviews} \tab List lens reviews\cr
\link[paws.developer.tools:wellarchitected_list_lens_shares]{list_lens_shares} \tab List the lens shares associated with the lens\cr
\link[paws.developer.tools:wellarchitected_list_milestones]{list_milestones} \tab List all milestones for an existing workload\cr
\link[paws.developer.tools:wellarchitected_list_notifications]{list_notifications} \tab List lens notifications\cr
\link[paws.developer.tools:wellarchitected_list_share_invitations]{list_share_invitations} \tab List the workload invitations\cr
\link[paws.developer.tools:wellarchitected_list_tags_for_resource]{list_tags_for_resource} \tab List the tags for a resource\cr
\link[paws.developer.tools:wellarchitected_list_workloads]{list_workloads} \tab List workloads\cr
\link[paws.developer.tools:wellarchitected_list_workload_shares]{list_workload_shares} \tab List the workload shares associated with the workload\cr
\link[paws.developer.tools:wellarchitected_tag_resource]{tag_resource} \tab Adds one or more tags to the specified resource\cr
\link[paws.developer.tools:wellarchitected_untag_resource]{untag_resource} \tab Deletes specified tags from a resource\cr
\link[paws.developer.tools:wellarchitected_update_answer]{update_answer} \tab Update the answer to a specific question in a workload review\cr
\link[paws.developer.tools:wellarchitected_update_global_settings]{update_global_settings} \tab Updates whether the Amazon Web Services account is opted into organization sharing features\cr
\link[paws.developer.tools:wellarchitected_update_lens_review]{update_lens_review} \tab Update lens review\cr
\link[paws.developer.tools:wellarchitected_update_share_invitation]{update_share_invitation} \tab Update a workload invitation\cr
\link[paws.developer.tools:wellarchitected_update_workload]{update_workload} \tab Update an existing workload\cr
\link[paws.developer.tools:wellarchitected_update_workload_share]{update_workload_share} \tab Update a workload share\cr
\link[paws.developer.tools:wellarchitected_upgrade_lens_review]{upgrade_lens_review} \tab Upgrade lens review
}
}

\examples{
\dontrun{
svc <- wellarchitected()
svc$associate_lenses(
  Foo = 123
)
}

}
