% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{backupstorage}
\alias{backupstorage}
\title{AWS Backup Storage}
\usage{
backupstorage(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
The frontend service for Cryo Storage.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- backupstorage(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.storage:backupstorage_delete_object]{delete_object} \tab Delete Object from the incremental base Backup\cr
\link[paws.storage:backupstorage_get_chunk]{get_chunk} \tab Gets the specified object's chunk\cr
\link[paws.storage:backupstorage_get_object_metadata]{get_object_metadata} \tab Get metadata associated with an Object\cr
\link[paws.storage:backupstorage_list_chunks]{list_chunks} \tab List chunks in a given Object\cr
\link[paws.storage:backupstorage_list_objects]{list_objects} \tab List all Objects in a given Backup\cr
\link[paws.storage:backupstorage_notify_object_complete]{notify_object_complete} \tab Complete upload\cr
\link[paws.storage:backupstorage_put_chunk]{put_chunk} \tab Upload chunk\cr
\link[paws.storage:backupstorage_put_object]{put_object} \tab Upload object that can store object metadata String and data blob in single API call using inline chunk field\cr
\link[paws.storage:backupstorage_start_object]{start_object} \tab Start upload containing one or many chunks
}
}

\examples{
\dontrun{
svc <- backupstorage()
svc$delete_object(
  Foo = 123
)
}

}
