% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{mturk}
\alias{mturk}
\title{Amazon Mechanical Turk}
\usage{
mturk(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Mechanical Turk API Reference
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- mturk(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.analytics:mturk_accept_qualification_request]{accept_qualification_request} \tab The AcceptQualificationRequest operation approves a Worker's request for a Qualification\cr
\link[paws.analytics:mturk_approve_assignment]{approve_assignment} \tab The ApproveAssignment operation approves the results of a completed assignment\cr
\link[paws.analytics:mturk_associate_qualification_with_worker]{associate_qualification_with_worker} \tab The AssociateQualificationWithWorker operation gives a Worker a Qualification\cr
\link[paws.analytics:mturk_create_additional_assignments_for_hit]{create_additional_assignments_for_hit} \tab The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT\cr
\link[paws.analytics:mturk_create_hit]{create_hit} \tab The CreateHIT operation creates a new Human Intelligence Task (HIT)\cr
\link[paws.analytics:mturk_create_hit_type]{create_hit_type} \tab The CreateHITType operation creates a new HIT type\cr
\link[paws.analytics:mturk_create_hit_with_hit_type]{create_hit_with_hit_type} \tab The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation\cr
\link[paws.analytics:mturk_create_qualification_type]{create_qualification_type} \tab The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure\cr
\link[paws.analytics:mturk_create_worker_block]{create_worker_block} \tab The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs\cr
\link[paws.analytics:mturk_delete_hit]{delete_hit} \tab The DeleteHIT operation is used to delete HIT that is no longer needed\cr
\link[paws.analytics:mturk_delete_qualification_type]{delete_qualification_type} \tab The DeleteQualificationType deletes a Qualification type and deletes any HIT types that are associated with the Qualification type\cr
\link[paws.analytics:mturk_delete_worker_block]{delete_worker_block} \tab The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs\cr
\link[paws.analytics:mturk_disassociate_qualification_from_worker]{disassociate_qualification_from_worker} \tab The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user\cr
\link[paws.analytics:mturk_get_account_balance]{get_account_balance} \tab The GetAccountBalance operation retrieves the Prepaid HITs balance in your Amazon Mechanical Turk account if you are a Prepaid Requester\cr
\link[paws.analytics:mturk_get_assignment]{get_assignment} \tab The GetAssignment operation retrieves the details of the specified Assignment\cr
\link[paws.analytics:mturk_get_file_upload_url]{get_file_upload_url} \tab The GetFileUploadURL operation generates and returns a temporary URL\cr
\link[paws.analytics:mturk_get_hit]{get_hit} \tab The GetHIT operation retrieves the details of the specified HIT\cr
\link[paws.analytics:mturk_get_qualification_score]{get_qualification_score} \tab The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type\cr
\link[paws.analytics:mturk_get_qualification_type]{get_qualification_type} \tab The GetQualificationTypeoperation retrieves information about a Qualification type using its ID\cr
\link[paws.analytics:mturk_list_assignments_for_hit]{list_assignments_for_hit} \tab The ListAssignmentsForHIT operation retrieves completed assignments for a HIT\cr
\link[paws.analytics:mturk_list_bonus_payments]{list_bonus_payments} \tab The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment\cr
\link[paws.analytics:mturk_list_hi_ts]{list_hi_ts} \tab The ListHITs operation returns all of a Requester's HITs\cr
\link[paws.analytics:mturk_list_hi_ts_for_qualification_type]{list_hi_ts_for_qualification_type} \tab The ListHITsForQualificationType operation returns the HITs that use the given Qualification type for a Qualification requirement\cr
\link[paws.analytics:mturk_list_qualification_requests]{list_qualification_requests} \tab The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type\cr
\link[paws.analytics:mturk_list_qualification_types]{list_qualification_types} \tab The ListQualificationTypes operation returns a list of Qualification types, filtered by an optional search term\cr
\link[paws.analytics:mturk_list_reviewable_hi_ts]{list_reviewable_hi_ts} \tab The ListReviewableHITs operation retrieves the HITs with Status equal to Reviewable or Status equal to Reviewing that belong to the Requester calling the operation\cr
\link[paws.analytics:mturk_list_review_policy_results_for_hit]{list_review_policy_results_for_hit} \tab The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies for a given HIT\cr
\link[paws.analytics:mturk_list_worker_blocks]{list_worker_blocks} \tab The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs\cr
\link[paws.analytics:mturk_list_workers_with_qualification_type]{list_workers_with_qualification_type} \tab The ListWorkersWithQualificationType operation returns all of the Workers that have been associated with a given Qualification type\cr
\link[paws.analytics:mturk_notify_workers]{notify_workers} \tab The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID\cr
\link[paws.analytics:mturk_reject_assignment]{reject_assignment} \tab The RejectAssignment operation rejects the results of a completed assignment\cr
\link[paws.analytics:mturk_reject_qualification_request]{reject_qualification_request} \tab The RejectQualificationRequest operation rejects a user's request for a Qualification\cr
\link[paws.analytics:mturk_send_bonus]{send_bonus} \tab The SendBonus operation issues a payment of money from your account to a Worker\cr
\link[paws.analytics:mturk_send_test_event_notification]{send_test_event_notification} \tab The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification\cr
\link[paws.analytics:mturk_update_expiration_for_hit]{update_expiration_for_hit} \tab The UpdateExpirationForHIT operation allows you update the expiration time of a HIT\cr
\link[paws.analytics:mturk_update_hit_review_status]{update_hit_review_status} \tab The UpdateHITReviewStatus operation updates the status of a HIT\cr
\link[paws.analytics:mturk_update_hit_type_of_hit]{update_hit_type_of_hit} \tab The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT\cr
\link[paws.analytics:mturk_update_notification_settings]{update_notification_settings} \tab The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type\cr
\link[paws.analytics:mturk_update_qualification_type]{update_qualification_type} \tab The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure
}
}

\examples{
\dontrun{
svc <- mturk()
svc$accept_qualification_request(
  Foo = 123
)
}

}
