% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{route53recoverycluster}
\alias{route53recoverycluster}
\title{Route53 Recovery Cluster}
\usage{
route53recoverycluster(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Welcome to the Routing Control (Recovery Cluster) API Reference Guide
for Amazon Route 53 Application Recovery Controller.

With Route 53 ARC, you can use routing control with extreme reliability
to recover applications by rerouting traffic across Availability Zones
or Amazon Web Services Regions. Routing controls are simple on/off
switches hosted on a highly available cluster in Route 53 ARC. A cluster
provides a set of five redundant Regional endpoints against which you
can run API calls to get or update the state of routing controls. To
implement failover, you set one routing control to ON and another one to
OFF, to reroute traffic from one Availability Zone or Amazon Web
Services Region to another.

\emph{Be aware that you must specify a Regional endpoint for a cluster when
you work with API cluster operations to get or update routing control
states in Route 53 ARC.} In addition, you must specify the US West
(Oregon) Region for Route 53 ARC API calls. For example, use the
parameter \verb{--region us-west-2} with AWS CLI commands. For more
information, see \href{https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.update.api.html}{Get and update routing control states using the API}
in the Amazon Route 53 Application Recovery Controller Developer Guide.

This API guide includes information about the API operations for how to
get and update routing control states in Route 53 ARC. To work with
routing control in Route 53 ARC, you must first create the required
components (clusters, control panels, and routing controls) using the
recovery cluster configuration API.

For more information about working with routing control in Route 53 ARC,
see the following:
\itemize{
\item Create clusters, control panels, and routing controls by using API
operations. For more information, see the \href{https://docs.aws.amazon.com/recovery-cluster/latest/api/}{Recovery Control Configuration API Reference Guide for Amazon Route 53 Application Recovery Controller}.
\item Learn about the components in recovery control, including clusters,
routing controls, and control panels, and how to work with Route 53
ARC in the Amazon Web Services console. For more information, see
\href{https://docs.aws.amazon.com/r53recovery/latest/dg/introduction-components.html#introduction-components-routing}{Recovery control components}
in the Amazon Route 53 Application Recovery Controller Developer
Guide.
\item Route 53 ARC also provides readiness checks that continually audit
resources to help make sure that your applications are scaled and
ready to handle failover traffic. For more information about the
related API operations, see the \href{https://docs.aws.amazon.com/recovery-readiness/latest/api/}{Recovery Readiness API Reference Guide for Amazon Route 53 Application Recovery Controller}.
\item For more information about creating resilient applications and
preparing for recovery readiness with Route 53 ARC, see the \href{https://docs.aws.amazon.com/r53recovery/latest/dg/}{Amazon Route 53 Application Recovery Controller Developer Guide}.
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- route53recoverycluster(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.networking:route53recoverycluster_get_routing_control_state]{get_routing_control_state} \tab Get the state for a routing control\cr
\link[paws.networking:route53recoverycluster_list_routing_controls]{list_routing_controls} \tab List routing control names and Amazon Resource Names (ARNs), as well as the routing control state for each routing control, along with the control panel name and control panel ARN for the routing controls\cr
\link[paws.networking:route53recoverycluster_update_routing_control_state]{update_routing_control_state} \tab Set the state of the routing control to reroute traffic\cr
\link[paws.networking:route53recoverycluster_update_routing_control_states]{update_routing_control_states} \tab Set multiple routing control states
}
}

\examples{
\dontrun{
svc <- route53recoverycluster()
svc$get_routing_control_state(
  Foo = 123
)
}

}
