% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{normalizeData}
\alias{normalizeData}
\title{Normalize data according to a canonical order}
\usage{
normalizeData(df, ..., .palist = NULL, .sortRows = TRUE)
}
\arguments{
\item{df}{a data frame with pairs of vertices given in columns \code{pa1} and \code{pa2}, and item response data in other columns}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{.palist}{a character vector giving an order to use instead of the default}

\item{.sortRows}{logical. Using the same order, sort rows in addition to vertex pairs.}
}
\description{
Pairwise comparison data are not commutative.
Alice beating Bob in chess is equivalent to Bob losing to
Alice. \code{normalizeData} assigns an arbitrary order to all
vertices and reorders vertices column-wise to match,
flipping signs as needed.
}
\examples{
df <- data.frame(pa1=NA, pa2=NA, i1=c(1, -1))
df[1,paste0('pa',1:2)] <- c('a','b')
df[2,paste0('pa',1:2)] <- c('b','a')
normalizeData(df)
}
