% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{parInterval}
\alias{parInterval}
\title{Produce data suitable for plotting parameter estimates}
\usage{
parInterval(fit, pars, nameVec, label = withoutIndex(pars[1]), width = 0.8)
}
\arguments{
\item{fit}{a \code{\link[rstan:stanfit-class]{stanfit}} object}

\item{pars}{a vector of parameter names}

\item{nameVec}{a vector of explanatory parameters names}

\item{label}{column name for \code{nameVec}}

\item{width}{a width in probability units for the uncertainty interval}
}
\value{
A data.frame with the following columns:
\describe{
\item{L}{Lower quantile}
\item{M}{Median}
\item{U}{Upper quantile}
\item{\emph{label}}{\emph{nameVec}}
}
}
\description{
Produce data suitable for plotting parameter estimates
}
\examples{
\donttest{ vignette('manual', 'pcFactorStan') }
}
\seealso{
Other data extractor: 
\code{\link{parDistributionCustom}()},
\code{\link{responseCurve}()}
}
\concept{data extractor}
