% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NPEtetra}
\alias{NPEtetra}
\title{The vertices of the Proportional Edge (PE) Proximity Region in a tetrahedron}
\usage{
NPEtetra(pt, r, th, M = "CM", rv = NULL)
}
\arguments{
\item{pt}{A 3D point whose PE proximity region is to be computed.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{th}{Four 3D points, stacked row-wise, each row representing a vertex of the tetrahedron.}

\item{M}{The center to be used in the construction of the vertex regions in the tetrahedron, \code{th}.
Currently it only takes "CC" for circumcenter and "CM" for center of mass; default="CM".}

\item{rv}{Index of the vertex region containing the point, either 1, 2, 3, 4 (default is \code{NULL}).}
}
\value{
Vertices of the tetrahedron which constitutes the PE proximity region with expansion parameter
\code{r} and circumcenter (or center of mass) for a point \code{pt} in the tetrahedron
}
\description{
Returns the vertices of the PE proximity region (which is itself a tetrahedron) for a point in the
tetrahedron \code{th}.

PE proximity region is defined with respect to the tetrahedron \code{th}
with expansion parameter \eqn{r \ge 1} and vertex regions based on the center \code{M} which is circumcenter ("CC") or
center of mass ("CM") of \code{th} with default="CM".

Vertex regions are labeled as 1,2,3,4 rowwise for the vertices of the tetrahedron \code{th}.
\code{rv} is the index of the vertex region \code{pt} resides, with default=\code{NULL}.
If \code{pt} is outside of \code{th}, it returns \code{NULL} for the proximity region.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)
n<-10  #try also n<-20

dat<-runif.tetra(n,tetra)$g

M<-"CM"  #try also M<-"CC"
r<-1.5

NPEtetra(dat[1,],r,tetra)  #uses the default M="CM"
NPEtetra(dat[1,],r,tetra,M)

NPEtetra(dat[5,],r,tetra,M)

NPEtetra(c(.4,.4,.4),r,tetra,M)
NPEtetra(c(.5,.5,.5),r,tetra,M)

#or try
RV<-rv.tetraCM(dat[1,],tetra)$rv
NPEtetra(dat[1,],r,tetra,M,rv=RV)

NPEtetra(c(-1,-1,-1),r,tetra,M,rv=NULL)

P1<-c(.1,.1,.1)
P2<-c(.5,.5,.5)
NPEtetra(P1,r,tetra,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NPEstdtetra}}, \code{\link{NPEtri}} and \code{\link{NPEint}}
}
