% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{plotASarcsMT}
\alias{plotASarcsMT}
\title{The plot of the arcs of Arc Slice Proximity Catch Digraph (AS-PCD) for a 2D data set -
multiple triangle case}
\usage{
plotASarcsMT(
  Xp,
  Yp,
  M = "CC",
  asp = NA,
  main = "",
  xlab = "",
  ylab = "",
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangulation. The Delaunay
triangles partition the convex hull of \code{Yp} points.}

\item{M}{The center of the triangle. "CC" stands for circumcenter of each Delaunay triangle \code{tri}
or 3D point in barycentric coordinates which serves as a center in the interior of each Delaunay triangle;
default is \code{M}="CC" i.e. the circumcenter of each triangle.}

\item{asp}{A numeric value, giving the aspect ratio for y axis to x-axis y/x (default is \code{NA}),
see the official help for \code{asp} by typing "? asp".}

\item{main}{An overall title for the plot (default="").}

\item{xlab, ylab}{Titles for the x and y axes, respectively (default="" for both).}

\item{xlim, ylim}{Numeric vectors of length 2, giving the x- and y-coordinate ranges
(default=\code{NULL} for both).}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
A plot of the arcs of the AS-PCD for a 2D data set \code{Xp} where AS proximity regions
are defined with respect to the Delaunay triangles based on \code{Yp} points; also plots the Delaunay triangles
based on \code{Yp} points
}
\description{
Plots the arcs of AS-PCD whose vertices are the data points in \code{Xp} and Delaunay triangles based on \code{Yp} points.

AS proximity regions are constructed with respect to the Delaunay triangles based on \code{Yp} points, i.e.,
AS proximity regions are defined only for \code{Xp} points inside the convex hull of \code{Yp} points.
That is, arcs may exist for \code{Xp} points only inside the convex hull of \code{Yp} points.

Vertex regions are based on the center \code{M}="CC"
for circumcenter of each Delaunay triangle or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of each Delaunay triangle; default is \code{M}="CC" i.e. circumcenter of each triangle.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}) for more on AS-PCDs.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

plotASarcsMT(Xp,Yp,M,xlab="",ylab="")
plotASarcsMT(Xp,Yp,M,asp=1,xlab="",ylab="")

plotASarcsMT(Xp,Yp[1:3,],M,xlab="",ylab="")

Xlim<-range(Xp[,1],Yp[,1])
Ylim<-range(Xp[,2],Yp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plotASarcsMT(Xp,Yp,M,xlab="",ylab="",xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01))
plotASarcsMT(Xp,Yp,M,asp=1,xlab="",ylab="",xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01))

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotASarcsTri}}, \code{\link{plotPEarcsTri}}, \code{\link{plotPEarcsMT}},
\code{\link{plotCSarcsTri}}, and \code{\link{plotCSarcsMT}}
}
