% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{ArcsCS}
\alias{ArcsCS}
\title{The arcs of Central Similarity Proximity Catch Digraph (CS-PCD) for 2D data - multiple triangle case}
\usage{
ArcsCS(Xp, Yp, t, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the CS-PCD.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 3D point in barycentric coordinates which serves as a center in the interior of each Delaunay
triangle, default for \eqn{M=(1,1,1)} which is the center of mass of each triangle.}
}
\value{
A \code{list} with the elements
\item{type}{A description of the type of the digraph}
\item{parameters}{Parameters of the digraph, here, it is the center used to construct the edge regions.}
\item{tess.points}{Points on which the tessellation of the study region is performed, here, tessellation
is Delaunay triangulation based on \code{Yp} points.}
\item{tess.name}{Name of data set used in tessellation, it is \code{Yp} for this function}
\item{vertices}{Vertices of the digraph, \code{Xp} points}
\item{vert.name}{Name of the data set which constitute the vertices of the digraph}
\item{S}{Tails (or sources) of the arcs of CS-PCD for 2D data set \code{Xp} as vertices of the digraph}
\item{E}{Heads (or arrow ends) of the arcs of CS-PCD for 2D data set \code{Xp} as vertices of the digraph}
\item{mtitle}{Text for \code{"main"} title in the plot of the digraph}
\item{quant}{Various quantities for the digraph: number of vertices, number of partition points,
number of intervals, number of arcs, and arc density.}
}
\description{
An object of class \code{"PCDs"}.
Returns arcs as tails (or sources) and heads (or arrow ends) of Central Similarity Proximity Catch Digraph
(CS-PCD) whose vertices are the data points in \code{Xp} in the multiple triangle case
and related parameters and the quantities of the digraph.

CS proximity regions are
defined with respect to the Delaunay triangles based on \code{Yp} points with expansion parameter \eqn{t>0} and
edge regions in each triangle are based on the center \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of each Delaunay triangle (default for \eqn{M=(1,1,1)} which is the center of mass of
the triangle). Each Delaunay triangle is first converted to an (nonscaled) basic triangle so that
\code{M} will be the same type of center for each Delaunay triangle (this conversion is not necessary when \code{M} is \eqn{CM}).

Convex hull of \code{Yp} is partitioned by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles whose union constitutes the
convex hull of \code{Yp} points). For the number of arcs, loops are not allowed so arcs are only possible
for points inside the convex hull of \code{Yp} points.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}) for more on CS-PCDs.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
\dontrun{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-15; ny<-5;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
#try also Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

tau<-1.5  #try also tau<-2

Arcs<-ArcsCS(Xp,Yp,tau,M)
#or use the default center Arcs<-ArcsCS(Xp,Yp,tau)
Arcs
summary(Arcs)
plot(Arcs)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ArcsCStri}}, \code{\link{ArcsAS}} and \code{\link{ArcsPE}}
}
\author{
Elvan Ceyhan
}
