% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{Gam2PEtri}
\alias{Gam2PEtri}
\title{The indicator for two points constituting a dominating set for Proportional Edge Proximity Catch Digraphs
(PE-PCDs) - one triangle case}
\usage{
Gam2PEtri(
  p1,
  p2,
  Xp,
  tri,
  r,
  M = c(1, 1, 1),
  rv1 = NULL,
  rv2 = NULL,
  ch.data.pnts = FALSE
)
}
\arguments{
\item{p1, p2}{Two 2D points to be tested for constituting a dominating set of the PE-PCD.}

\item{Xp}{A set of 2D points which constitutes the vertices of the PE-PCD.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri}
which may be entered as "CC" as well;
default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.}

\item{rv1, rv2}{The indices of the vertices whose regions contains \code{p1} and \code{p2}, respectively.
They take the vertex labels as \eqn{1,2,3} as in the row order of the vertices in \code{tri}
(default is \code{NULL} for both).}

\item{ch.data.pnts}{A logical argument for checking whether points \code{p1} and \code{p2} are
data points in \code{Xp} or not (default is \code{FALSE}).}
}
\value{
\eqn{I(}\{\code{p1,p2}\} is a dominating set of the PE-PCD\eqn{)} where the vertices of the PE-PCD are the 2D data set \code{Xp}),
that is, returns 1 if \{\code{p1,p2}\} is a dominating set of PE-PCD, returns 0 otherwise
}
\description{
Returns \eqn{I(}\{\code{p1,p2}\} is a dominating set of the PE-PCD\eqn{)} where the vertices of the PE-PCD
are the 2D data set \code{Xp}), that is, returns 1 if \{\code{p1,p2}\} is a dominating set of PE-PCD,
returns 0 otherwise.

Point, \code{p1}, is in the region of vertex \code{rv1} (default is \code{NULL}) and point, \code{p2}, is in the region of vertex \code{rv2}
(default is \code{NULL}); vertices (and hence \code{rv1} and \code{rv2}) are labeled as \eqn{1,2,3} in the order they are stacked
row-wise in \code{tri}.

PE proximity regions are defined with respect to the triangle \code{tri} and vertex regions
are based on center \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri} or circumcenter of \code{tri}; default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.

\code{ch.data.pnts} is for checking whether points \code{p1} and \code{p2} are data points in \code{Xp} or not
(default is \code{FALSE}), so by default this function checks whether the points \code{p1} and \code{p2} would be a
dominating set if they actually were in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:masa-2007,ceyhan:dom-num-NPE-Spat2011,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10  #try also n<-20

set.seed(1)
Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

r<-1.5  #try also r<-2

Gam2PEtri(Xp[1,],Xp[2,],Xp,Tr,r,M)

ind.gam2<-vector()
for (i in 1:(n-1))
  for (j in (i+1):n)
  {if (Gam2PEtri(Xp[i,],Xp[j,],Xp,Tr,r,M)==1)
   ind.gam2<-rbind(ind.gam2,c(i,j))}
ind.gam2

#or try
rv1<-rv.tri.cent(Xp[1,],Tr,M)$rv;
rv2<-rv.tri.cent(Xp[2,],Tr,M)$rv
Gam2PEtri(Xp[1,],Xp[2,],Xp,Tr,r,M,rv1,rv2)

Gam2PEtri(Xp[1,],c(1,2),Xp,Tr,r,M,ch.data.pnts = FALSE)
#gives an error message if ch.data.pnts = TRUE
#since not both points, p1 and p2, are data points in Xp
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Gam2PEbas.tri}}, \code{\link{Gam2AStri}}, and \code{\link{Gam2PEtetra}}
}
\author{
Elvan Ceyhan
}
