% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{rel.edges.tri.cent}
\alias{rel.edges.tri.cent}
\title{The indices of the \code{M}-edge regions in a triangle that contains the points in a give data set}
\usage{
rel.edges.tri.cent(Xp, tri, M)
}
\arguments{
\item{Xp}{A set of 2D points representing the set of data points for which indices of the edge regions
containing them are to be determined.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}.}
}
\value{
A \code{list} with the elements
\item{re}{Indices (i.e., a \code{vector} of indices) of the edges whose region contains points in \code{Xp}
in the triangle \code{tri}}
\item{tri}{The vertices of the triangle, where row number corresponds to the vertex index opposite to edge
whose index is given in re.}
\item{desc}{Description of the edge labels as \code{"Edge labels are AB=3, BC=1, and AC=2"}.}
}
\description{
Returns the indices of the edges whose regions contain the points in data set \code{Xp} in
a triangle \code{tri}\eqn{=T(A,B,C)} and edge regions are based on the center \eqn{M=(m_1,m_2)} in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri}
(see the plots in the example for illustrations).

The vertices of the  triangle \code{tri} are labeled as
\eqn{1=A}, \eqn{2=B}, and \eqn{3=C} also according to the row number the vertex is recorded in \code{tri}
and the corresponding edges are \eqn{1=BC}, \eqn{2=AC}, and \eqn{3=AB}.

If a point in \code{Xp} is not inside \code{tri}, then the function yields \code{NA} as output for that entry.
The corresponding edge region is the polygon
with the vertex, \code{M}, and vertices other than the non-adjacent vertex, i.e., edge region 1 is the triangle
\eqn{T(B,M,C)}, edge region 2 is \eqn{T(A,M,C)} and edge region 3 is \eqn{T(A,B,M)}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

M<-c(1.6,1.2)

P<-c(.4,.2)
rel.edges.tri.cent(P,Tr,M)

n<-20  #try also n<-40
set.seed(1)
Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

(re<-rel.edges.tri.cent(Xp,Tr,M))

D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

Xlim<-range(Tr[,1],Xp[,1])
Ylim<-range(Tr[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

if (dimension(M)==3) {M<-bary2cart(M,Tr)}
#need to run this when M is given in barycentric coordinates

plot(Tr,pch=".",xlab="",ylab="",
main="Scatterplot of data points \n and the M-edge regions",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(Xp,pch=".",col=1)
L<-Tr; R<-rbind(M,M,M)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

xc<-Tr[,1]+c(-.02,.03,.02)
yc<-Tr[,2]+c(.02,.02,.04)
txt.str<-c("A","B","C")
text(xc,yc,txt.str)

txt<-rbind(M,Ds)
xc<-txt[,1]+c(.05,.06,-.05,-.02)
yc<-txt[,2]+c(.03,.03,.05,-.08)
txt.str<-c("M","re=2","re=3","re=1")
text(xc,yc,txt.str)
text(Xp,labels=factor(re$re))
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rel.edges.triCM}}, \code{\link{rel.verts.tri.cent}} and \code{\link{rel.verts.tri.nd}}
}
\author{
Elvan Ceyhan
}
