% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxGeometry.R
\name{dist.point2plane}
\alias{dist.point2plane}
\title{The distance from a point to a plane spanned
by three 3D points}
\usage{
dist.point2plane(p, a, b, c)
}
\arguments{
\item{p}{A 3D point, distance from \code{p} to the plane
passing through points \code{a}, \code{b},
and \code{c} are to be computed.}

\item{a, b, c}{3D points that determine the plane
(i.e., through which the plane is passing).}
}
\value{
A \code{list} with two elements
\item{dis}{Distance from point \code{p} to the plane
spanned by 3D points \code{a}, \code{b}, and \code{c}}
\item{cl2pl}{The closest point on the plane
spanned by 3D points \code{a}, \code{b},
and \code{c} to the point \code{p}}
}
\description{
Returns the distance from a point \code{p} to the plane
passing through points \code{a}, \code{b}, and \code{c} in 3D space.
}
\examples{
\dontrun{
P<-c(5,2,40)
P1<-c(1,2,3); P2<-c(3,9,12); P3<-c(1,1,3);

dis<-dist.point2plane(P,P1,P2,P3);
dis
Pr<-dis$proj #projection on the plane

xseq<-seq(0,10,l=5)  #try also l=10, 20, or 100
yseq<-seq(0,10,l=5)  #try also l=10, 20, or 100

pl.grid<-Plane(P1,P2,P3,xseq,yseq)$z

plot3D::persp3D(z = pl.grid, x = xseq, y = yseq, theta =225, phi = 30,
ticktype = "detailed",
expand = 0.7, facets = FALSE, scale = TRUE,
main="Point P and its Orthogonal Projection \n on the Plane Defined by P1, P2, P3")
#plane spanned by points P1, P2, P3
#add the vertices of the tetrahedron
plot3D::points3D(P[1],P[2],P[3], add=TRUE)
plot3D::points3D(Pr[1],Pr[2],Pr[3], add=TRUE)
plot3D::segments3D(P[1], P[2], P[3], Pr[1], Pr[2],Pr[3], add=TRUE,lwd=2)

plot3D::text3D(P[1]-.5,P[2],P[3]+1, c("P"),add=TRUE)
plot3D::text3D(Pr[1]-.5,Pr[2],Pr[3]+2, c("Pr"),add=TRUE)

persp(xseq,yseq,pl.grid, xlab="x",ylab="y",zlab="z",theta = -30,
phi = 30, expand = 0.5, col = "lightblue",
      ltheta = 120, shade = 0.05, ticktype = "detailed")

}

}
\seealso{
\code{\link{dist.point2line}}, \code{\link{dist.point2set}},
and \code{\link{Dist}}
}
\author{
Elvan Ceyhan
}
