% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatternGen.R
\name{rassoc.matern}
\alias{rassoc.matern}
\title{Generation of points associated (in a Matern-like fashion)
to a given set of points}
\usage{
rassoc.matern(n, Yp, e)
}
\arguments{
\item{n}{A positive integer
representing the number of points to be generated.}

\item{Yp}{A set of 2D points representing the reference points.
The generated points are associated
(in a Matern-cluster like fashion) with these points.}

\item{e}{A positive real number representing the radius of the balls
centered at \code{Yp} points.
Only these balls are allowed for the generated points
(i.e., generated points would be in the union of these balls).}
}
\value{
A \code{list} with the elements
\item{type}{The type of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{parameters}{Radial (i.e., circular) attraction parameter
of the association pattern.}
\item{ref.points}{The input set of attraction points \code{Yp},
i.e., points with which generated points are associated.}
\item{gen.points}{The output set of generated points associated
with \code{Yp} points.}
\item{tri.Yp}{Logical output for triangulation
based on \code{Yp} points should be implemented or not.
if \code{TRUE} triangulation based on \code{Yp} points is
to be implemented (default is set to \code{FALSE}).}
\item{desc.pat}{Description of the point pattern}
\item{num.points}{The \code{vector} of two numbers,
which are the number of generated points and the number of
attraction (i.e., \code{Yp}) points.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}-
and \eqn{y}-coordinates of the generated points.}
}
\description{
An object of class \code{"Patterns"}.
Generates \code{n} 2D points uniformly in \eqn{\cup B(y_i,e)}
where \eqn{Y_p=(y_1,y_2,\ldots,y_{n_y})}
with \eqn{n_y} being number of \code{Yp} points
for various values of \code{e} under the association pattern
and \eqn{B(y_i,e)} is the ball centered
at \eqn{y_i} with radius \code{e}.

The pattern resembles the Matern cluster pattern
(see \code{\link[spatstat.random]{rMatClust}} in the
\code{spatstat.random} package for further information
(\insertCite{baddeley:2005;textual}{pcds}).
\code{rMatClust(kappa, scale, mu, win)} in the simplest
case generates a uniform Poisson point process of "parent" points
with intensity \code{kappa}.
Then each parent point is replaced by a random cluster of
"offspring" points, the number of points per cluster
being Poisson(\code{mu}) distributed,
and their positions being placed
and uniformly inside a disc of radius scale centered on the parent point.
The resulting point pattern is a realization of the classical
"stationary Matern cluster process" generated inside the
window \code{win}.

The main difference of \code{rassoc.matern}
and \code{\link[spatstat.random]{rMatClust}}
is that the parent points are \code{Yp} points
which are given beforehand
and we do not discard them in the end in \code{rassoc.matern}
and the offspring points are the points associated
with the reference points, \code{Yp};
\code{e} must be positive and very large values of \code{e}
provide patterns close to CSR.

This function is also very similar to \code{\link{rassoc.circular}},
where \code{\link{rassoc.circular}} needs the study window to be specified,
while \code{rassoc.matern} does not.
}
\examples{
\dontrun{
nx<-100; ny<-4;  #try also nx<-1000; ny<-10;

e<-.15;
 #try also e<-1.1; #closer to CSR than association, as e is large

#Y points uniform in unit square
Y<-cbind(runif(ny),runif(ny))

Xdt<-rassoc.matern(nx,Y,e)
Xdt
summary(Xdt)
plot(Xdt,asp=1)

Xdt<-Xdt$gen.points
Xlim<-range(Xdt[,1],Y[,1]);
Ylim<-range(Xdt[,2],Y[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Y,asp=1,xlab="x",ylab="y",
main="Matern-like Association of X points with Y Points",
     xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01),
     pch=16,col=2,lwd=2)
points(Xdt)

a1<-0; a2<-10;
b1<-0; b2<-5;
e<-1.1;

#Y points uniform in a rectangle
Y<-cbind(runif(ny,a1,a2),runif(ny,b1,b2))
#try also Y<-cbind(runif(ny,a1,a2/2),runif(ny,b1,b2/2))

Xdt<-rassoc.matern(nx,Y,e)$gen.points
Xlim<-range(Xdt[,1],Y[,1]);
Ylim<-range(Xdt[,2],Y[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Y,asp=1,xlab="x",ylab="y",
main="Matern-like Association of X points with Y Points",
     xlim=Xlim+xd*c(-.01,.01),ylim=Ylim+yd*c(-.01,.01),pch=16,col=2,lwd=2)
points(Xdt)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rassoc.circular}}, \code{\link{rassoc.std.tri}},
\code{\link{rassocII.std.tri}}, \code{\link{rassoc.multi.tri}},
\code{\link{rseg.circular}}, and \code{\link[spatstat.random]{rMatClust}}
in the \code{spatstat.random} package
}
\author{
Elvan Ceyhan
}
