% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pct.R
\name{get_pct_zones}
\alias{get_pct_zones}
\title{Get zone results from the PCT}
\usage{
get_pct_zones(
  region = NULL,
  purpose = "commute",
  geography = "lsoa",
  extension = ".geojson"
)
}
\arguments{
\item{region}{The PCT region or local authority to download data from (e.g. \code{west-yorkshire} or \code{Leeds}).
See \code{View(pct_regions_lookup)} for a full list of possible region names.}

\item{purpose}{Trip purpose (typically \code{school} or \code{commute})}

\item{geography}{Geographic resolution of outputs, \code{msoa} or \code{lsoa} (the default)}

\item{extension}{The type of file to download (only \code{.geojson} supported at present)}
}
\description{
Wrapper around \verb{[get_pct()]} that gets zone data from the PCT.
}
\examples{
\donttest{
# don't test to reduce build times
z = get_pct_zones("isle-of-wight")
plot(z)
}
}
