% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rtaxonkit.R
\name{taxonkit_lca}
\alias{taxonkit_lca}
\title{Compute Lowest Common Ancestor (LCA) of TaxIDs}
\usage{
taxonkit_lca(
  file_path,
  buffer_size = "1M",
  separator = " ",
  skip_deleted = FALSE,
  skip_unfound = FALSE,
  taxids_field = NULL,
  text = FALSE,
  data_dir = NULL
)
}
\arguments{
\item{file_path}{The path to the input file containing TaxIDs. Or file text (text=TRUE)}

\item{buffer_size}{The size of the line buffer (supported units: K, M, G).}

\item{separator}{The separator for TaxIDs.}

\item{skip_deleted}{Whether to skip deleted TaxIDs and compute with the remaining ones.}

\item{skip_unfound}{Whether to skip unfound TaxIDs and compute with the remaining ones.}

\item{taxids_field}{The field index of TaxIDs. Input data should be tab-separated (default 1).}

\item{text}{logical}

\item{data_dir}{directory containing nodes.dmp and names.dmp (default "/Users/asa/.taxonkit")}
}
\value{
A character vector containing the computed LCAs.
}
\description{
This function uses the "taxonkit lca" command to compute the Lowest Common Ancestor (LCA) of TaxIDs.
}
\examples{
\dontrun{
taxonkit_lca("239934, 239935, 349741", text = TRUE, separator = ", ")
}
}
