% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pdols.R
\name{coef.pdols}
\alias{coef.pdols}
\title{Panel DOLS Coefficients}
\usage{
\method{coef}{pdols}(object, type = c("ordinary", "cte"), ...)
}
\arguments{
\item{object}{An object of class pdols}

\item{type}{The type of coefficient to return. Either ordinary dols ("ordinary") or common time effects ("cte")}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A vector of the specified coefficients
}
\description{
Panel DOLS Coefficients
}
\examples{
data("marksul2003")
result <- pdols(formula = Y ~ X + Z - 1,
                index = c("Country", "Year"),
                data = marksul2003,
                p = 2,
                icase = "constant")
coef(result, type = "cte")
coef(result, type = "o")
}
\references{
Mark, N. C. and Sul, D. (2003), Cointegration Vector Estimation by Panel DOLS and Long-run Money Demand. Oxford Bulletin of Economics and Statistics, 65: 655-680. <DOI:10.1111/j.1468-0084.2003.00066.x>
}

